/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.math;

import hu.akarnokd.rxjava2.math.ObservableWithSource;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.observers.DeferredScalarObserver;
import java.util.Comparator;

final class ObservableMinMax<T>
extends ObservableWithSource<T, T> {
    final Comparator<? super T> comparator;
    final int flag;

    ObservableMinMax(ObservableSource<T> source, Comparator<? super T> comparator, int flag) {
        super(source);
        this.comparator = comparator;
        this.flag = flag;
    }

    protected void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new MinMaxSubscriber<T>(observer, this.comparator, this.flag));
    }

    static final class MinMaxSubscriber<T>
    extends DeferredScalarObserver<T, T> {
        private static final long serialVersionUID = -4484454790848904397L;
        final Comparator<? super T> comparator;
        final int flag;

        MinMaxSubscriber(Observer<? super T> actual, Comparator<? super T> comparator, int flag) {
            super(actual);
            this.comparator = comparator;
            this.flag = flag;
        }

        public void onNext(T value) {
            try {
                Object v = this.value;
                if (v != null) {
                    if (this.comparator.compare(v, value) * this.flag > 0) {
                        this.value = value;
                    }
                } else {
                    this.value = value;
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.s.dispose();
                this.actual.onError(ex);
            }
        }
    }
}

