/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.FlowableTransformer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiConsumer;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableCoalesce<T, R>
extends Flowable<R>
implements FlowableTransformer<T, R> {
    final Publisher<T> source;
    final Callable<R> containerSupplier;
    final BiConsumer<R, T> coalescer;
    final int bufferSize;

    FlowableCoalesce(Publisher<T> source, Callable<R> containerSupplier, BiConsumer<R, T> coalescer, int bufferSize) {
        this.source = source;
        this.containerSupplier = containerSupplier;
        this.coalescer = coalescer;
        this.bufferSize = bufferSize;
    }

    public Publisher<R> apply(Flowable<T> upstream) {
        return new FlowableCoalesce<T, R>(upstream, this.containerSupplier, this.coalescer, this.bufferSize);
    }

    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new CoalesceSubscriber<T, R>(s, this.containerSupplier, this.coalescer, this.bufferSize));
    }

    static final class CoalesceSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -6157179110480235565L;
        final Subscriber<? super R> actual;
        final Callable<R> containerSupplier;
        final BiConsumer<R, T> coalescer;
        final AtomicLong requested;
        final int bufferSize;
        volatile SimplePlainQueue<T> queue;
        Subscription upstream;
        R container;
        volatile boolean done;
        volatile boolean cancelled;
        Throwable error;
        long emitted;

        CoalesceSubscriber(Subscriber<? super R> actual, Callable<R> containerSupplier, BiConsumer<R, T> coalescer, int bufferSize) {
            this.actual = actual;
            this.containerSupplier = containerSupplier;
            this.coalescer = coalescer;
            this.requested = new AtomicLong();
            this.bufferSize = bufferSize;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                SimplePlainQueue<T> q = this.queue;
                if (q == null || q.isEmpty()) {
                    R c = this.container;
                    try {
                        if (c == null) {
                            this.container = c = this.containerSupplier.call();
                        }
                        this.coalescer.accept(c, t);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        this.upstream.cancel();
                        this.container = null;
                        this.actual.onError(ex);
                        return;
                    }
                    long r = this.requested.get();
                    long e = this.emitted;
                    if (e != r) {
                        this.container = null;
                        this.actual.onNext(c);
                        this.emitted = e + 1L;
                    }
                    if (this.decrementAndGet() == 0) {
                        return;
                    }
                }
            } else {
                SpscLinkedArrayQueue q = this.queue;
                if (q == null) {
                    this.queue = q = new SpscLinkedArrayQueue(this.bufferSize);
                }
                q.offer(t);
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            if (this.getAndIncrement() == 0) {
                this.container = null;
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.drainLoop();
        }

        void drainLoop() {
            int missed = 1;
            long e = this.emitted;
            R c = this.container;
            Subscriber<? super R> a = this.actual;
            do {
                boolean empty;
                if (this.cancelled) {
                    this.container = null;
                    return;
                }
                boolean d = this.done;
                SimplePlainQueue<T> q = this.queue;
                boolean bl = empty = q == null || q.isEmpty();
                if (!empty) {
                    try {
                        Object v;
                        if (c == null) {
                            this.container = c = this.containerSupplier.call();
                        }
                        while ((v = q.poll()) != null) {
                            this.coalescer.accept(c, v);
                        }
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        this.container = null;
                        a.onError(ex);
                        return;
                    }
                }
                if (c != null && e != this.requested.get()) {
                    a.onNext(c);
                    c = null;
                    this.container = null;
                    ++e;
                }
                if (d && c == null) {
                    Throwable ex = this.error;
                    this.container = null;
                    if (ex != null) {
                        a.onError(ex);
                    } else {
                        a.onComplete();
                    }
                    return;
                }
                this.emitted = e;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

