/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;

final class FlowableRepeatScalar<T>
extends Flowable<T> {
    final T value;

    FlowableRepeatScalar(T value) {
        this.value = value;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        if (s instanceof ConditionalSubscriber) {
            s.onSubscribe(new RepeatScalarConditionalSubscription<T>((ConditionalSubscriber)s, this.value));
        } else {
            s.onSubscribe(new RepeatScalarSubscription<T>(s, this.value));
        }
    }

    static final class RepeatScalarConditionalSubscription<T>
    extends BasicQueueSubscription<T> {
        private static final long serialVersionUID = -231033913007168200L;
        final ConditionalSubscriber<? super T> actual;
        T value;
        volatile boolean cancelled;

        RepeatScalarConditionalSubscription(ConditionalSubscriber<? super T> actual, T value) {
            this.actual = actual;
            this.value = value;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n) && BackpressureHelper.add((AtomicLong)((Object)this), (long)n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastpath();
                } else {
                    this.slowpath(n);
                }
            }
        }

        void fastpath() {
            T v = this.value;
            while (!this.cancelled) {
                this.actual.tryOnNext(v);
            }
        }

        void slowpath(long r) {
            T v = this.value;
            long e = 0L;
            while (true) {
                if (e != r) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.actual.tryOnNext(v)) continue;
                    ++e;
                    continue;
                }
                if (this.cancelled) {
                    return;
                }
                r = this.get();
                if (e != r) continue;
                r = this.addAndGet(-e);
                if (r == 0L) break;
                e = 0L;
            }
        }

        public void cancel() {
            this.cancelled = true;
        }

        public int requestFusion(int mode) {
            return mode & 1;
        }

        public T poll() throws Exception {
            return this.value;
        }

        public boolean isEmpty() {
            return this.value == null;
        }

        public void clear() {
            this.value = null;
        }
    }

    static final class RepeatScalarSubscription<T>
    extends BasicQueueSubscription<T> {
        private static final long serialVersionUID = -231033913007168200L;
        final Subscriber<? super T> actual;
        T value;
        volatile boolean cancelled;

        RepeatScalarSubscription(Subscriber<? super T> actual, T value) {
            this.actual = actual;
            this.value = value;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n) && BackpressureHelper.add((AtomicLong)((Object)this), (long)n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastpath();
                } else {
                    this.slowpath(n);
                }
            }
        }

        void fastpath() {
            T v = this.value;
            while (!this.cancelled) {
                this.actual.onNext(v);
            }
        }

        void slowpath(long r) {
            T v = this.value;
            long e = 0L;
            while (true) {
                if (e != r) {
                    if (this.cancelled) {
                        return;
                    }
                    this.actual.onNext(v);
                    ++e;
                    continue;
                }
                if (this.cancelled) {
                    return;
                }
                r = this.get();
                if (e != r) continue;
                r = this.addAndGet(-e);
                if (r == 0L) break;
                e = 0L;
            }
        }

        public void cancel() {
            this.cancelled = true;
        }

        public int requestFusion(int mode) {
            return mode & 1;
        }

        public T poll() throws Exception {
            return this.value;
        }

        public boolean isEmpty() {
            return this.value == null;
        }

        public void clear() {
            this.value = null;
        }
    }
}

