/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableSwitchIfEmptyManyArray<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final Flowable<T> source;
    final Publisher<? extends T>[] alternatives;

    FlowableSwitchIfEmptyManyArray(Flowable<T> source, Publisher<? extends T>[] alternatives) {
        this.source = source;
        this.alternatives = alternatives;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        SwitchManySubscriber<T> parent = new SwitchManySubscriber<T>(s, this.alternatives);
        s.onSubscribe(parent);
        parent.drain((Publisher<T>)this.source);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableSwitchIfEmptyManyArray<T>(upstream, this.alternatives);
    }

    static final class SwitchManySubscriber<T>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -174718617614474267L;
        final Subscriber<? super T> actual;
        final AtomicLong requested;
        final AtomicReference<Subscription> s;
        final Publisher<? extends T>[] alternatives;
        int index;
        boolean hasValue;
        volatile boolean active;

        SwitchManySubscriber(Subscriber<? super T> actual, Publisher<? extends T>[] alternatives) {
            this.actual = actual;
            this.alternatives = alternatives;
            this.requested = new AtomicLong();
            this.s = new AtomicReference();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                Subscription a = this.s.get();
                if (a != null) {
                    a.request(n);
                }
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel(this.s);
        }

        public void onSubscribe(Subscription s) {
            long n;
            if (SubscriptionHelper.replace(this.s, (Subscription)s) && (n = this.requested.get()) != 0L) {
                s.request(n);
            }
        }

        public void onNext(T t) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.hasValue) {
                this.actual.onComplete();
            } else {
                this.active = false;
                this.drain(null);
            }
        }

        void drain(Publisher<? extends T> source) {
            if (this.getAndIncrement() == 0) {
                do {
                    if (SubscriptionHelper.isCancelled((Subscription)this.s.get())) {
                        return;
                    }
                    if (this.active) continue;
                    if (source == null) {
                        int idx = this.index;
                        Publisher<? extends T>[] a = this.alternatives;
                        if (idx == a.length) {
                            this.actual.onComplete();
                            return;
                        }
                        source = a[idx];
                        if (source == null) {
                            this.actual.onError((Throwable)new NullPointerException("The " + idx + "th alternative Publisher is null"));
                            return;
                        }
                        this.index = idx + 1;
                    }
                    this.active = true;
                    source.subscribe((Subscriber)this);
                    source = null;
                } while (this.decrementAndGet() != 0);
            }
        }
    }
}

