/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.processors;

import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.processors.FlowableProcessor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableProcessorWrap<T>
extends FlowableProcessor<T> {
    final Processor<T, T> source;
    volatile boolean done;
    Throwable error;

    FlowableProcessorWrap(Processor<T, T> source) {
        this.source = source;
    }

    public void onSubscribe(Subscription s) {
        this.source.onSubscribe(s);
    }

    public void onNext(T t) {
        this.source.onNext(t);
    }

    public void onError(Throwable t) {
        this.error = t;
        this.done = true;
        this.source.onError(t);
    }

    public void onComplete() {
        this.done = true;
        this.source.onComplete();
    }

    public boolean hasSubscribers() {
        throw new UnsupportedOperationException();
    }

    public boolean hasThrowable() {
        return this.done && this.error != null;
    }

    public boolean hasComplete() {
        return this.done && this.error == null;
    }

    public Throwable getThrowable() {
        return this.done ? this.error : null;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe((Subscriber)new WrapSubscriber(s));
    }

    final class WrapSubscriber
    extends AtomicBoolean
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -6891177704330298695L;
        final Subscriber<? super T> actual;
        Subscription s;

        WrapSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.s = SubscriptionHelper.CANCELLED;
            this.actual.onError(t);
        }

        public void onComplete() {
            this.s = SubscriptionHelper.CANCELLED;
            this.actual.onComplete();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            if (this.compareAndSet(false, true)) {
                this.s.cancel();
                this.s = SubscriptionHelper.CANCELLED;
            }
        }
    }
}

