/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.BasicRefQueueSubscription;
import hu.akarnokd.rxjava2.basetypes.Nono;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoTimeout
extends Nono {
    final Nono source;
    final Publisher<?> other;
    final Nono fallback;

    NonoTimeout(Nono source, Publisher<?> other, Nono fallback) {
        this.source = source;
        this.other = other;
        this.fallback = fallback;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        MainSubscriber parent = new MainSubscriber(s, this.fallback);
        s.onSubscribe((Subscription)parent);
        this.other.subscribe((Subscriber)parent.other);
        this.source.subscribe(parent);
    }

    static final class MainSubscriber
    extends BasicRefQueueSubscription<Void, Subscription>
    implements Subscriber<Void> {
        private static final long serialVersionUID = 5699062216456523328L;
        final Subscriber<? super Void> actual;
        final Nono fallback;
        final OtherSubscriber other;
        final AtomicBoolean once;

        MainSubscriber(Subscriber<? super Void> actual, Nono fallback) {
            this.actual = actual;
            this.fallback = fallback;
            this.other = new OtherSubscriber();
            this.once = new AtomicBoolean();
        }

        public void cancel() {
            SubscriptionHelper.cancel((AtomicReference)this);
            SubscriptionHelper.cancel((AtomicReference)this.other);
        }

        public void onSubscribe(Subscription s) {
            SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s);
        }

        public void onNext(Void t) {
        }

        public void onError(Throwable t) {
            SubscriptionHelper.cancel((AtomicReference)this.other);
            if (this.once.compareAndSet(false, true)) {
                this.actual.onError(t);
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            SubscriptionHelper.cancel((AtomicReference)this.other);
            if (this.once.compareAndSet(false, true)) {
                this.actual.onComplete();
            }
        }

        void otherError(Throwable t) {
            SubscriptionHelper.cancel((AtomicReference)this);
            if (this.once.compareAndSet(false, true)) {
                this.actual.onError(t);
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        void otherComplete() {
            SubscriptionHelper.cancel((AtomicReference)this);
            if (this.once.compareAndSet(false, true)) {
                Nono f = this.fallback;
                if (f == null) {
                    this.actual.onError((Throwable)new TimeoutException());
                } else {
                    f.subscribe(new FallbackSubscriber());
                }
            }
        }

        void fallbackSubscribe(Subscription s) {
            SubscriptionHelper.replace((AtomicReference)this, (Subscription)s);
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<Object> {
            private static final long serialVersionUID = -7257274632636068061L;
            boolean done;

            OtherSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(Object t) {
                if (!this.done) {
                    SubscriptionHelper.cancel((AtomicReference)this);
                    this.onComplete();
                }
            }

            public void onError(Throwable t) {
                MainSubscriber.this.otherError(t);
            }

            public void onComplete() {
                MainSubscriber.this.otherComplete();
            }
        }

        final class FallbackSubscriber
        implements Subscriber<Void> {
            FallbackSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                MainSubscriber.this.fallbackSubscribe(s);
            }

            public void onNext(Void t) {
            }

            public void onError(Throwable t) {
                MainSubscriber.this.actual.onError(t);
            }

            public void onComplete() {
                MainSubscriber.this.actual.onComplete();
            }
        }
    }
}

