/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Perhaps;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class PerhapsDelay<T>
extends Perhaps<T> {
    final Perhaps<T> source;
    final Publisher<?> other;

    PerhapsDelay(Perhaps<T> source, Publisher<?> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new DelaySubscriber<T>(s, this.other));
    }

    static final class DelaySubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -7563209762781178448L;
        final Publisher<?> other;
        final OtherSubscriber inner;
        Subscription s;
        Throwable error;

        DelaySubscriber(Subscriber<? super T> actual, Publisher<?> other) {
            super(actual);
            this.other = other;
            this.inner = new OtherSubscriber();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            this.error = t;
            this.other.subscribe((Subscriber)this.inner);
        }

        public void onComplete() {
            this.other.subscribe((Subscriber)this.inner);
        }

        public void cancel() {
            super.cancel();
            this.s.cancel();
            SubscriptionHelper.cancel((AtomicReference)this.inner);
        }

        void otherNext() {
            Throwable ex = this.error;
            if (ex != null) {
                this.actual.onError(ex);
                return;
            }
            Object v = this.value;
            if (v != null) {
                this.complete(v);
            } else {
                this.actual.onComplete();
            }
        }

        void otherError(Throwable ex) {
            Throwable ex0 = this.error;
            if (ex0 != null) {
                this.actual.onError((Throwable)new CompositeException(new Throwable[]{ex0, ex}));
            } else {
                this.actual.onError(ex);
            }
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<Object> {
            private static final long serialVersionUID = -2194292167160252795L;
            boolean done;

            OtherSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(Object t) {
                ((Subscription)this.get()).cancel();
                this.done = true;
                DelaySubscriber.this.otherNext();
            }

            public void onError(Throwable t) {
                if (this.done) {
                    RxJavaPlugins.onError((Throwable)t);
                } else {
                    this.done = true;
                    DelaySubscriber.this.otherError(t);
                }
            }

            public void onComplete() {
                if (!this.done) {
                    this.done = true;
                    DelaySubscriber.this.otherNext();
                }
            }
        }
    }
}

