/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Perhaps;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class PerhapsRetryWhile<T>
extends Perhaps<T> {
    final Perhaps<T> source;
    final Predicate<? super Throwable> predicate;

    PerhapsRetryWhile(Perhaps<T> source, Predicate<? super Throwable> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        RetrySubscriber<T> parent = new RetrySubscriber<T>(s, this.predicate, this.source);
        s.onSubscribe(parent);
        parent.subscribeNext();
    }

    static final class RetrySubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -1726278593241855499L;
        final AtomicInteger wip;
        final AtomicReference<Subscription> s;
        final Perhaps<T> source;
        final Predicate<? super Throwable> predicate;
        volatile boolean active;

        RetrySubscriber(Subscriber<? super T> actual, Predicate<? super Throwable> predicate, Perhaps<T> source) {
            super(actual);
            this.predicate = predicate;
            this.source = source;
            this.wip = new AtomicInteger();
            this.s = new AtomicReference();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.replace(this.s, (Subscription)s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            boolean b;
            try {
                b = this.predicate.test((Object)t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.actual.onError((Throwable)new CompositeException(new Throwable[]{t, ex}));
                return;
            }
            if (b) {
                this.active = false;
                this.subscribeNext();
            } else {
                this.actual.onError(t);
            }
        }

        void subscribeNext() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (SubscriptionHelper.isCancelled((Subscription)this.s.get())) {
                        return;
                    }
                    if (this.active) continue;
                    this.active = true;
                    this.source.subscribe(this);
                } while (this.wip.decrementAndGet() != 0);
            }
        }

        public void onComplete() {
            Object v = this.value;
            if (v != null) {
                this.value = null;
                this.complete(v);
            } else {
                this.actual.onComplete();
            }
        }

        public void cancel() {
            super.cancel();
            SubscriptionHelper.cancel(this.s);
        }
    }
}

