/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloDelaySubscription<T>
extends Solo<T> {
    final Solo<T> source;
    final Publisher<?> other;

    SoloDelaySubscription(Solo<T> source, Publisher<?> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        DelaySubscriptionSubscriber<? super T> parent = new DelaySubscriptionSubscriber<T>(s, this.source);
        s.onSubscribe(parent);
        this.other.subscribe((Subscriber)parent.other);
    }

    static final class DelaySubscriptionSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = 2365899367123544974L;
        final Solo<T> source;
        final OtherSubscriber other;

        DelaySubscriptionSubscriber(Subscriber<? super T> actual, Solo<T> source) {
            super(actual);
            this.source = source;
            this.other = new OtherSubscriber();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.replace((AtomicReference)this.other, (Subscription)s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            Object v = this.value;
            if (v == null) {
                this.actual.onComplete();
            } else {
                this.complete(v);
            }
        }

        public void cancel() {
            super.cancel();
        }

        void otherError(Throwable t) {
            this.actual.onError(t);
        }

        void otherComplete() {
            this.source.subscribe(this);
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<Object> {
            private static final long serialVersionUID = -4157815870217815859L;
            boolean once;

            OtherSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(Object t) {
                if (!this.once) {
                    this.once = true;
                    ((Subscription)this.get()).cancel();
                    DelaySubscriptionSubscriber.this.otherComplete();
                }
            }

            public void onError(Throwable t) {
                DelaySubscriptionSubscriber.this.otherError(t);
            }

            public void onComplete() {
                if (!this.once) {
                    this.once = true;
                    DelaySubscriptionSubscriber.this.otherComplete();
                }
            }
        }
    }
}

