/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloOnErrorResumeWith<T>
extends Solo<T> {
    final Solo<T> source;
    final Solo<T> next;

    SoloOnErrorResumeWith(Solo<T> source, Solo<T> next) {
        this.source = source;
        this.next = next;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new OnErrorResumeWithSubscriber<T>(s, this.next));
    }

    static final class OnErrorResumeWithSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -7631998337002592538L;
        final Solo<T> next;
        final NextSubscriber nextSubscriber;
        Subscription s;

        OnErrorResumeWithSubscriber(Subscriber<? super T> actual, Solo<T> next) {
            super(actual);
            this.next = next;
            this.nextSubscriber = new NextSubscriber();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            this.next.subscribe(this.nextSubscriber);
        }

        public void onComplete() {
            Object v = this.value;
            if (v != null) {
                this.complete(v);
            } else {
                this.actual.onComplete();
            }
        }

        public void cancel() {
            super.cancel();
            this.s.cancel();
            SubscriptionHelper.cancel((AtomicReference)this.nextSubscriber);
        }

        final class NextSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<T> {
            private static final long serialVersionUID = 5161815655607865861L;

            NextSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(T t) {
                OnErrorResumeWithSubscriber.this.onNext(t);
            }

            public void onError(Throwable t) {
                OnErrorResumeWithSubscriber.this.actual.onError(t);
            }

            public void onComplete() {
                OnErrorResumeWithSubscriber.this.onComplete();
            }
        }
    }
}

