/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.math;

import hu.akarnokd.rxjava2.math.FlowableSource;
import io.reactivex.internal.subscribers.DeferredScalarSubscriber;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class FlowableAverageFloat
extends FlowableSource<Number, Float> {
    FlowableAverageFloat(Publisher<Number> source) {
        super(source);
    }

    protected void subscribeActual(Subscriber<? super Float> observer) {
        this.source.subscribe((Subscriber)new AverageFloatSubscriber(observer));
    }

    static final class AverageFloatSubscriber
    extends DeferredScalarSubscriber<Number, Float> {
        private static final long serialVersionUID = 600979972678601618L;
        float accumulator;
        int count;

        AverageFloatSubscriber(Subscriber<? super Float> actual) {
            super(actual);
        }

        public void onNext(Number value) {
            this.accumulator += value.floatValue();
            ++this.count;
        }

        public void onComplete() {
            int c = this.count;
            if (c != 0) {
                this.complete(Float.valueOf(this.accumulator / (float)c));
            } else {
                this.actual.onComplete();
            }
        }
    }
}

