/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.FlowableTransformer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.Pow2;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableMapAsync<T, U, R>
extends Flowable<R>
implements FlowableTransformer<T, R> {
    final Flowable<T> source;
    final Function<? super T, ? extends Publisher<? extends U>> mapper;
    final BiFunction<? super T, ? super U, ? extends R> combiner;
    final int bufferSize;

    FlowableMapAsync(Flowable<T> source, Function<? super T, ? extends Publisher<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, int bufferSize) {
        this.source = source;
        this.mapper = mapper;
        this.combiner = combiner;
        this.bufferSize = bufferSize;
    }

    public Publisher<R> apply(Flowable<T> upstream) {
        return new FlowableMapAsync<T, U, R>(upstream, this.mapper, this.combiner, this.bufferSize);
    }

    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new MapAsyncSubscriber<T, U, R>(s, this.mapper, this.combiner, this.bufferSize));
    }

    static final class MapAsyncSubscriber<T, U, R>
    extends AtomicReferenceArray<T>
    implements FlowableSubscriber<T>,
    Subscription,
    AsyncSupport<U> {
        private static final long serialVersionUID = -1557840206706079339L;
        final Subscriber<? super R> actual;
        final Function<? super T, ? extends Publisher<? extends U>> mapper;
        final BiFunction<? super T, ? super U, ? extends R> combiner;
        final int bufferSize;
        final AtomicThrowable error;
        final AtomicLong requested;
        final AtomicInteger wip;
        final AtomicReference<InnerSubscriber<U>> current;
        static final InnerSubscriber INNER_CANCELLED = new InnerSubscriber(null);
        Subscription upstream;
        long producerIndex;
        long consumerIndex;
        int consumed;
        volatile boolean done;
        volatile boolean cancelled;
        U innerResult;
        long emitted;
        volatile int state;
        static final int STATE_FRESH = 0;
        static final int STATE_RUNNING = 1;
        static final int STATE_RESULT = 2;

        MapAsyncSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, int bufferSize) {
            super(Pow2.roundToPowerOfTwo((int)bufferSize));
            this.actual = actual;
            this.mapper = mapper;
            this.combiner = combiner;
            this.bufferSize = bufferSize;
            this.error = new AtomicThrowable();
            this.requested = new AtomicLong();
            this.wip = new AtomicInteger();
            this.current = new AtomicReference();
        }

        public void onNext(T t) {
            long pi = this.producerIndex;
            int m = this.length() - 1;
            int offset = (int)pi & m;
            this.lazySet(offset, t);
            this.producerIndex = pi + 1L;
            this.drain();
        }

        public void onError(Throwable t) {
            this.error.addThrowable(t);
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                this.cancelInner();
                if (this.wip.getAndIncrement() == 0) {
                    this.clear();
                }
            }
        }

        void cancelInner() {
            InnerSubscriber a = this.current.get();
            if (a != INNER_CANCELLED && (a = this.current.getAndSet(INNER_CANCELLED)) != null && a != INNER_CANCELLED) {
                a.cancel();
            }
        }

        void clear() {
            int n = this.length();
            for (int i = 0; i < n; ++i) {
                this.lazySet(i, null);
            }
            this.innerResult = null;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.actual.onSubscribe((Subscription)this);
                s.request((long)this.bufferSize);
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            int limit = this.bufferSize - (this.bufferSize >> 2);
            long e = this.emitted;
            long ci = this.consumerIndex;
            int f = this.consumed;
            int m = this.length() - 1;
            Subscriber<? super R> a = this.actual;
            while (true) {
                int w;
                boolean empty;
                Object t;
                int offset;
                boolean d;
                long r = this.requested.get();
                while (e != r) {
                    Object v;
                    if (this.cancelled) {
                        this.clear();
                        return;
                    }
                    d = this.done;
                    offset = (int)ci & m;
                    t = this.get(offset);
                    boolean bl = empty = t == null;
                    if (d && empty) {
                        Throwable ex = this.error.terminate();
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                    if (empty) break;
                    int s = this.state;
                    if (s == 0) {
                        Publisher p;
                        try {
                            p = (Publisher)ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper returned a null value");
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            this.error.addThrowable(ex);
                            p = null;
                        }
                        if (p != null) {
                            if (p instanceof Callable) {
                                try {
                                    Object u = ((Callable)p).call();
                                    v = u != null ? ObjectHelper.requireNonNull((Object)this.combiner.apply(t, u), (String)"The combiner returned a null value") : null;
                                }
                                catch (Throwable ex) {
                                    Exceptions.throwIfFatal((Throwable)ex);
                                    this.error.addThrowable(ex);
                                    v = null;
                                }
                                if (v != null) {
                                    a.onNext(v);
                                    ++e;
                                }
                            } else {
                                InnerSubscriber inner = new InnerSubscriber(this);
                                if (this.current.compareAndSet(null, inner)) {
                                    this.state = 1;
                                    p.subscribe(inner);
                                    break;
                                }
                            }
                        }
                        this.lazySet(offset, null);
                        ++ci;
                        if (++f != limit) continue;
                        f = 0;
                        this.upstream.request((long)limit);
                        continue;
                    }
                    if (s != 2) break;
                    U u = this.innerResult;
                    this.innerResult = null;
                    if (u != null) {
                        try {
                            v = ObjectHelper.requireNonNull((Object)this.combiner.apply(t, u), (String)"The combiner returned a null value");
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            this.error.addThrowable(ex);
                            v = null;
                        }
                        if (v != null) {
                            a.onNext(v);
                            ++e;
                        }
                    }
                    this.lazySet(offset, null);
                    ++ci;
                    if (++f == limit) {
                        f = 0;
                        this.upstream.request((long)limit);
                    }
                    this.state = 0;
                }
                if (e == r) {
                    if (this.cancelled) {
                        this.clear();
                        return;
                    }
                    d = this.done;
                    offset = (int)ci & m;
                    t = this.get(offset);
                    boolean bl = empty = t == null;
                    if (d && empty) {
                        Throwable ex = this.error.terminate();
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                }
                if (missed == (w = this.wip.get())) {
                    this.consumed = f;
                    this.consumerIndex = ci;
                    this.emitted = e;
                    if ((missed = this.wip.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        void clearCurrent() {
            InnerSubscriber<U> c = this.current.get();
            if (c != INNER_CANCELLED) {
                this.current.compareAndSet(c, null);
            }
        }

        @Override
        public void innerResult(U item) {
            this.innerResult = item;
            this.state = 2;
            this.clearCurrent();
            this.drain();
        }

        @Override
        public void innerError(Throwable ex) {
            this.error.addThrowable(ex);
            this.state = 2;
            this.clearCurrent();
            this.drain();
        }

        @Override
        public void innerComplete() {
            this.state = 2;
            this.clearCurrent();
            this.drain();
        }

        static final class InnerSubscriber<U>
        extends AtomicReference<Subscription>
        implements Subscriber<U> {
            private static final long serialVersionUID = 6335578148970008248L;
            final AsyncSupport<U> parent;
            boolean done;

            InnerSubscriber(AsyncSupport<U> parent) {
                this.parent = parent;
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(U t) {
                if (!this.done) {
                    ((Subscription)this.get()).cancel();
                    this.done = true;
                    this.parent.innerResult(t);
                }
            }

            public void onError(Throwable t) {
                if (!this.done) {
                    this.done = true;
                    this.parent.innerError(t);
                } else {
                    RxJavaPlugins.onError((Throwable)t);
                }
            }

            public void onComplete() {
                if (!this.done) {
                    this.done = true;
                    this.parent.innerComplete();
                }
            }

            void cancel() {
                SubscriptionHelper.cancel((AtomicReference)this);
            }
        }
    }

    static interface AsyncSupport<U> {
        public void innerResult(U var1);

        public void innerError(Throwable var1);

        public void innerComplete();
    }
}

