/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.async;

import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

final class FutureCompletable<T>
extends CountDownLatch
implements Future<T> {
    static final int STATE_ACTIVE = 0;
    static final int STATE_DONE = 1;
    static final int STATE_ERROR = 2;
    static final int STATE_CANCELLED = 3;
    final AtomicInteger once;
    Disposable onCancel;
    T value;
    Throwable error;

    FutureCompletable() {
        this(null);
    }

    FutureCompletable(Disposable onCancel) {
        super(1);
        this.onCancel = onCancel;
        this.once = new AtomicInteger();
    }

    public void complete(T value) {
        if (this.once.compareAndSet(0, 1)) {
            this.onCancel = null;
            this.value = value;
            this.countDown();
        }
    }

    public void completeExceptionally(Throwable error) {
        ObjectHelper.requireNonNull((Object)error, (String)"error is null");
        if (this.once.compareAndSet(0, 2)) {
            this.onCancel = null;
            this.error = error;
            this.countDown();
        } else {
            RxJavaPlugins.onError((Throwable)error);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.once.compareAndSet(0, 3)) {
            this.error = new CancellationException();
            this.countDown();
            Disposable d = this.onCancel;
            this.onCancel = null;
            if (d != null) {
                d.dispose();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.once.get() == 3;
    }

    @Override
    public boolean isDone() {
        return this.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        Throwable ex;
        if (this.getCount() != 0L) {
            this.await();
        }
        if ((ex = this.error) != null) {
            throw new ExecutionException(ex);
        }
        return this.value;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.getCount() != 0L && !this.await(timeout, unit)) {
            throw new TimeoutException();
        }
        Throwable ex = this.error;
        if (ex != null) {
            throw new ExecutionException(ex);
        }
        return this.value;
    }
}

