/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import hu.akarnokd.rxjava2.util.CompositeSubscription;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloAmbArray<T>
extends Solo<T> {
    final Solo<? extends T>[] sources;

    SoloAmbArray(Solo<? extends T>[] sources) {
        this.sources = sources;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        AmbSubscriber<T> parent = new AmbSubscriber<T>(s);
        s.onSubscribe(parent);
        for (Solo<T> solo : this.sources) {
            if (solo == null) {
                parent.onError(new NullPointerException("One of the sources is null"));
                break;
            }
            solo.subscribe(parent);
        }
    }

    static final class AmbSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -5477345444871880990L;
        final CompositeSubscription set = new CompositeSubscription();
        final AtomicBoolean once = new AtomicBoolean();

        AmbSubscriber(Subscriber<? super T> actual) {
            super(actual);
        }

        public void onSubscribe(Subscription s) {
            if (this.set.add(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.once.compareAndSet(false, true)) {
                this.set.cancel();
                this.complete(t);
            }
        }

        public void onError(Throwable t) {
            if (this.once.compareAndSet(false, true)) {
                this.set.cancel();
                this.actual.onError(t);
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            if (this.once.compareAndSet(false, true)) {
                this.set.cancel();
                this.actual.onComplete();
            }
        }

        public void cancel() {
            super.cancel();
            this.set.cancel();
        }
    }
}

