/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.debug.validator;

import hu.akarnokd.rxjava2.debug.validator.MultipleOnSubscribeCallsException;
import hu.akarnokd.rxjava2.debug.validator.MultipleTerminationsException;
import hu.akarnokd.rxjava2.debug.validator.NullOnErrorParameterException;
import hu.akarnokd.rxjava2.debug.validator.NullOnSubscribeParameterException;
import hu.akarnokd.rxjava2.debug.validator.OnSubscribeNotCalledException;
import hu.akarnokd.rxjava2.debug.validator.ProtocolNonConformanceException;
import hu.akarnokd.rxjava2.functions.PlainConsumer;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;

final class CompletableValidator
extends Completable {
    final Completable source;
    final PlainConsumer<ProtocolNonConformanceException> onViolation;

    CompletableValidator(Completable source, PlainConsumer<ProtocolNonConformanceException> onViolation) {
        this.source = source;
        this.onViolation = onViolation;
    }

    protected void subscribeActual(CompletableObserver s) {
        this.source.subscribe((CompletableObserver)new ValidatorConsumer(s, this.onViolation));
    }

    static final class ValidatorConsumer
    implements CompletableObserver,
    Disposable {
        final CompletableObserver actual;
        final PlainConsumer<ProtocolNonConformanceException> onViolation;
        Disposable upstream;
        boolean done;

        ValidatorConsumer(CompletableObserver actual, PlainConsumer<ProtocolNonConformanceException> onViolation) {
            this.actual = actual;
            this.onViolation = onViolation;
        }

        public void onSubscribe(Disposable d) {
            Disposable u;
            if (d == null) {
                this.onViolation.accept(new NullOnSubscribeParameterException());
            }
            if ((u = this.upstream) != null) {
                this.onViolation.accept(new MultipleOnSubscribeCallsException());
            }
            this.upstream = d;
            this.actual.onSubscribe((Disposable)this);
        }

        public void onError(Throwable e) {
            if (e == null) {
                this.onViolation.accept(new NullOnErrorParameterException());
            }
            if (this.upstream == null) {
                this.onViolation.accept(new OnSubscribeNotCalledException(e));
            }
            if (this.done) {
                this.onViolation.accept(new MultipleTerminationsException(e));
            } else {
                this.done = true;
                this.actual.onError(e);
            }
        }

        public void onComplete() {
            if (this.upstream == null) {
                OnSubscribeNotCalledException ex = new OnSubscribeNotCalledException();
                this.onViolation.accept(ex);
            }
            if (this.done) {
                this.onViolation.accept(new MultipleTerminationsException());
            } else {
                this.done = true;
                this.actual.onComplete();
            }
        }

        public void dispose() {
            this.upstream.dispose();
        }

        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }
}

