/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.debug.validator;

import hu.akarnokd.rxjava2.debug.SavedHooks;
import hu.akarnokd.rxjava2.debug.validator.CompletableValidator;
import hu.akarnokd.rxjava2.debug.validator.ConnectableFlowableValidator;
import hu.akarnokd.rxjava2.debug.validator.ConnectableObservableValidator;
import hu.akarnokd.rxjava2.debug.validator.FlowableValidator;
import hu.akarnokd.rxjava2.debug.validator.MaybeValidator;
import hu.akarnokd.rxjava2.debug.validator.ObservableValidator;
import hu.akarnokd.rxjava2.debug.validator.ParallelFlowableValidator;
import hu.akarnokd.rxjava2.debug.validator.ProtocolNonConformanceException;
import hu.akarnokd.rxjava2.debug.validator.SingleValidator;
import hu.akarnokd.rxjava2.functions.PlainConsumer;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.annotations.Nullable;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.Functions;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.parallel.ParallelFlowable;
import io.reactivex.plugins.RxJavaPlugins;

public final class RxJavaProtocolValidator {
    static volatile boolean enabled;
    static volatile PlainConsumer<ProtocolNonConformanceException> onViolation;
    static final PlainConsumer<ProtocolNonConformanceException> DEFAULT;

    private RxJavaProtocolValidator() {
        throw new IllegalStateException("No instances!");
    }

    public static void enable() {
        RxJavaProtocolValidator.enable(false);
    }

    public static SavedHooks enableAndChain() {
        return RxJavaProtocolValidator.enable(true);
    }

    static SavedHooks enable(boolean chain) {
        Function savePF;
        Function saveCO;
        Function saveCF;
        Function saveF;
        Function saveO;
        Function saveS;
        Function saveM;
        PlainConsumer<ProtocolNonConformanceException> h = onViolation;
        if (h == null) {
            h = DEFAULT;
        }
        final PlainConsumer<ProtocolNonConformanceException> handler = h;
        final Function saveC = RxJavaPlugins.getOnCompletableAssembly();
        Function oldCompletable = saveC;
        if (oldCompletable == null || !chain) {
            oldCompletable = Functions.identity();
        }
        final Function oldC = oldCompletable;
        RxJavaPlugins.setOnCompletableAssembly((Function)new Function<Completable, Completable>(){

            public Completable apply(Completable c) throws Exception {
                return (Completable)oldC.apply((Object)new CompletableValidator(c, handler));
            }
        });
        Function oldMaybe = saveM = RxJavaPlugins.getOnMaybeAssembly();
        if (oldMaybe == null || !chain) {
            oldMaybe = Functions.identity();
        }
        final Function oldM = oldMaybe;
        RxJavaPlugins.setOnMaybeAssembly((Function)new Function<Maybe, Maybe>(){

            public Maybe apply(Maybe c) throws Exception {
                return (Maybe)oldM.apply(new MaybeValidator(c, handler));
            }
        });
        Function oldSingle = saveS = RxJavaPlugins.getOnSingleAssembly();
        if (oldSingle == null || !chain) {
            oldSingle = Functions.identity();
        }
        final Function oldS = oldSingle;
        RxJavaPlugins.setOnSingleAssembly((Function)new Function<Single, Single>(){

            public Single apply(Single c) throws Exception {
                return (Single)oldS.apply(new SingleValidator(c, handler));
            }
        });
        Function oldObservable = saveO = RxJavaPlugins.getOnObservableAssembly();
        if (oldObservable == null || !chain) {
            oldObservable = Functions.identity();
        }
        final Function oldO = oldObservable;
        RxJavaPlugins.setOnObservableAssembly((Function)new Function<Observable, Observable>(){

            public Observable apply(Observable c) throws Exception {
                return (Observable)oldO.apply(new ObservableValidator(c, handler));
            }
        });
        Function oldFlowable = saveF = RxJavaPlugins.getOnFlowableAssembly();
        if (oldFlowable == null || !chain) {
            oldFlowable = Functions.identity();
        }
        final Function oldF = oldFlowable;
        RxJavaPlugins.setOnFlowableAssembly((Function)new Function<Flowable, Flowable>(){

            public Flowable apply(Flowable c) throws Exception {
                return (Flowable)oldF.apply(new FlowableValidator(c, handler));
            }
        });
        Function oldConnFlow = saveCF = RxJavaPlugins.getOnConnectableFlowableAssembly();
        if (oldConnFlow == null || !chain) {
            oldConnFlow = Functions.identity();
        }
        final Function oldCF = oldConnFlow;
        RxJavaPlugins.setOnConnectableFlowableAssembly((Function)new Function<ConnectableFlowable, ConnectableFlowable>(){

            public ConnectableFlowable apply(ConnectableFlowable c) throws Exception {
                return (ConnectableFlowable)oldCF.apply(new ConnectableFlowableValidator(c, handler));
            }
        });
        Function oldConnObs = saveCO = RxJavaPlugins.getOnConnectableObservableAssembly();
        if (oldConnObs == null || !chain) {
            oldConnObs = Functions.identity();
        }
        final Function oldCO = oldConnObs;
        RxJavaPlugins.setOnConnectableObservableAssembly((Function)new Function<ConnectableObservable, ConnectableObservable>(){

            public ConnectableObservable apply(ConnectableObservable c) throws Exception {
                return (ConnectableObservable)oldCO.apply(new ConnectableObservableValidator(c, handler));
            }
        });
        Function oldParFlow = savePF = RxJavaPlugins.getOnParallelAssembly();
        if (oldParFlow == null || !chain) {
            oldParFlow = Functions.identity();
        }
        final Function oldPF = oldParFlow;
        RxJavaPlugins.setOnParallelAssembly((Function)new Function<ParallelFlowable, ParallelFlowable>(){

            public ParallelFlowable apply(ParallelFlowable c) throws Exception {
                return (ParallelFlowable)oldPF.apply(new ParallelFlowableValidator(c, handler));
            }
        });
        enabled = true;
        return new SavedHooks(){

            @Override
            public void restore() {
                RxJavaPlugins.setOnCompletableAssembly((Function)saveC);
                RxJavaPlugins.setOnSingleAssembly((Function)saveS);
                RxJavaPlugins.setOnMaybeAssembly((Function)saveM);
                RxJavaPlugins.setOnObservableAssembly((Function)saveO);
                RxJavaPlugins.setOnFlowableAssembly((Function)saveF);
                RxJavaPlugins.setOnConnectableObservableAssembly((Function)saveCO);
                RxJavaPlugins.setOnConnectableFlowableAssembly((Function)saveCF);
                RxJavaPlugins.setOnParallelAssembly((Function)savePF);
            }
        };
    }

    public static void disable() {
        RxJavaPlugins.setOnCompletableAssembly(null);
        RxJavaPlugins.setOnSingleAssembly(null);
        RxJavaPlugins.setOnMaybeAssembly(null);
        RxJavaPlugins.setOnObservableAssembly(null);
        RxJavaPlugins.setOnFlowableAssembly(null);
        RxJavaPlugins.setOnConnectableObservableAssembly(null);
        RxJavaPlugins.setOnConnectableFlowableAssembly(null);
        RxJavaPlugins.setOnParallelAssembly(null);
        enabled = false;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setOnViolationHandler(@Nullable PlainConsumer<ProtocolNonConformanceException> handler) {
        onViolation = handler;
    }

    @Nullable
    public static PlainConsumer<ProtocolNonConformanceException> getOnViolationHandler() {
        return onViolation;
    }

    static {
        DEFAULT = new PlainConsumer<ProtocolNonConformanceException>(){

            @Override
            public void accept(ProtocolNonConformanceException e) {
                RxJavaPlugins.onError((Throwable)e);
            }
        };
    }
}

