/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.FlowableTransformer;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.HalfSerializer;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableRequestSample<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final Flowable<T> source;
    final Publisher<?> other;

    FlowableRequestSample(Flowable<T> source, Publisher<?> other) {
        this.source = source;
        this.other = other;
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableRequestSample<T>(upstream, this.other);
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        RequestSample<? super T> parent = new RequestSample<T>(s);
        s.onSubscribe(parent);
        this.other.subscribe((Subscriber)parent.otherConsumer);
        this.source.subscribe(parent);
    }

    static final class RequestSample<T>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final AtomicLong downstreamRequests;
        final AtomicLong upstreamRequests;
        final AtomicReference<Subscription> upstream;
        final OtherConsumer otherConsumer;
        final AtomicInteger wip;
        final AtomicThrowable error;
        long emitted;
        boolean done;

        RequestSample(Subscriber<? super T> actual) {
            this.actual = actual;
            this.downstreamRequests = new AtomicLong();
            this.upstreamRequests = new AtomicLong();
            this.upstream = new AtomicReference();
            this.otherConsumer = new OtherConsumer(this);
            this.error = new AtomicThrowable();
            this.wip = new AtomicInteger();
        }

        public void onSubscribe(Subscription s) {
            SubscriptionHelper.deferredSetOnce(this.upstream, (AtomicLong)this.upstreamRequests, (Subscription)s);
        }

        public void onNext(T t) {
            if (!this.done) {
                long e = this.emitted;
                if (this.downstreamRequests.get() != e) {
                    this.emitted = e + 1L;
                    HalfSerializer.onNext(this.actual, t, (AtomicInteger)this.wip, (AtomicThrowable)this.error);
                } else {
                    this.done = true;
                    this.cancel();
                    HalfSerializer.onError(this.actual, (Throwable)new MissingBackpressureException("Downstream is not ready to receive the next upstream item."), (AtomicInteger)this.wip, (AtomicThrowable)this.error);
                }
            }
        }

        public void onError(Throwable t) {
            if (!this.done) {
                this.done = true;
                this.otherConsumer.cancel();
                HalfSerializer.onError(this.actual, (Throwable)t, (AtomicInteger)this.wip, (AtomicThrowable)this.error);
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.otherConsumer.cancel();
                HalfSerializer.onComplete(this.actual, (AtomicInteger)this.wip, (AtomicThrowable)this.error);
            }
        }

        void otherNext() {
            SubscriptionHelper.deferredRequest(this.upstream, (AtomicLong)this.upstreamRequests, (long)1L);
        }

        void otherError(Throwable t) {
            SubscriptionHelper.cancel(this.upstream);
            HalfSerializer.onError(this.actual, (Throwable)t, (AtomicInteger)this.wip, (AtomicThrowable)this.error);
        }

        void otherComplete() {
            SubscriptionHelper.cancel(this.upstream);
            HalfSerializer.onComplete(this.actual, (AtomicInteger)this.wip, (AtomicThrowable)this.error);
        }

        public void request(long n) {
            BackpressureHelper.add((AtomicLong)this.downstreamRequests, (long)n);
        }

        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
            this.otherConsumer.cancel();
        }

        static final class OtherConsumer
        extends AtomicReference<Subscription>
        implements FlowableSubscriber<Object> {
            private static final long serialVersionUID = -9069889200779269650L;
            final RequestSample<?> parent;

            OtherConsumer(RequestSample<?> parent) {
                this.parent = parent;
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(Object t) {
                this.parent.otherNext();
            }

            public void onError(Throwable t) {
                this.parent.otherError(t);
            }

            public void onComplete() {
                this.parent.otherComplete();
            }

            void cancel() {
                SubscriptionHelper.cancel((AtomicReference)this);
            }
        }
    }
}

