/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.subscribers.BasicFuseableSubscriber;
import org.reactivestreams.Subscriber;

final class SoloMapError<T>
extends Solo<T> {
    final Solo<T> source;
    final Function<? super Throwable, ? extends Throwable> errorMapper;

    SoloMapError(Solo<T> source, Function<? super Throwable, ? extends Throwable> errorMapper) {
        this.source = source;
        this.errorMapper = errorMapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe((Subscriber<? super T>)new MapErrorSubscriber<T>(s, this.errorMapper));
    }

    static final class MapErrorSubscriber<T>
    extends BasicFuseableSubscriber<T, T> {
        final Function<? super Throwable, ? extends Throwable> errorMapper;

        MapErrorSubscriber(Subscriber<? super T> actual, Function<? super Throwable, ? extends Throwable> errorMapper) {
            super(actual);
            this.errorMapper = errorMapper;
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            Throwable ex;
            try {
                ex = (Throwable)ObjectHelper.requireNonNull((Object)this.errorMapper.apply((Object)t), (String)"The errorMapper returned a null Throwable");
            }
            catch (Throwable exc) {
                Exceptions.throwIfFatal((Throwable)exc);
                ex = new CompositeException(new Throwable[]{t, exc});
            }
            super.onError(ex);
        }

        public int requestFusion(int mode) {
            QueueSubscription qs = this.qs;
            return qs != null ? qs.requestFusion(mode) : 0;
        }

        public T poll() throws Exception {
            return (T)this.qs.poll();
        }
    }
}

