/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoLambdaSubscriber
extends AtomicReference<Subscription>
implements Subscriber<Void>,
Disposable {
    private static final long serialVersionUID = 2347769328526232927L;
    final Action onComplete;
    final Consumer<? super Throwable> onError;

    NonoLambdaSubscriber(Action onComplete, Consumer<? super Throwable> onError) {
        this.onComplete = onComplete;
        this.onError = onError;
    }

    public void onSubscribe(Subscription s) {
        SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s);
    }

    public void onNext(Void t) {
    }

    public void onError(Throwable t) {
        try {
            this.onError.accept((Object)t);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, ex}));
        }
    }

    public void onComplete() {
        try {
            this.onComplete.run();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            RxJavaPlugins.onError((Throwable)ex);
        }
    }

    public boolean isDisposed() {
        return SubscriptionHelper.isCancelled((Subscription)((Subscription)this.get()));
    }

    public void dispose() {
        SubscriptionHelper.cancel((AtomicReference)this);
    }
}

