/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.BasicNonoIntQueueSubscription;
import hu.akarnokd.rxjava2.basetypes.Nono;
import hu.akarnokd.rxjava2.basetypes.NonoRepeatWhen;
import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.PublishProcessor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoRetryWhen
extends Nono {
    final Nono source;
    final Function<? super Flowable<Throwable>, ? extends Publisher<?>> handler;

    NonoRetryWhen(Nono source, Function<? super Flowable<Throwable>, ? extends Publisher<?>> handler) {
        this.source = source;
        this.handler = handler;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        Publisher p;
        FlowableProcessor processor = PublishProcessor.create().toSerialized();
        try {
            p = (Publisher)this.handler.apply((Object)processor);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        RetryWhenMainSubscriber parent = new RetryWhenMainSubscriber(s, (FlowableProcessor<Throwable>)processor, this.source);
        s.onSubscribe((Subscription)parent);
        p.subscribe((Subscriber)parent.inner);
        this.source.subscribe(parent);
    }

    static final class RetryWhenMainSubscriber
    extends BasicNonoIntQueueSubscription
    implements Subscriber<Void>,
    NonoRepeatWhen.RedoSupport {
        private static final long serialVersionUID = 6463015514357680572L;
        final Subscriber<? super Void> actual;
        final AtomicReference<Subscription> s;
        final NonoRepeatWhen.RedoInnerSubscriber inner;
        final AtomicBoolean once;
        final FlowableProcessor<Throwable> processor;
        final Nono source;
        volatile boolean active;

        RetryWhenMainSubscriber(Subscriber<? super Void> actual, FlowableProcessor<Throwable> processor, Nono source) {
            this.actual = actual;
            this.s = new AtomicReference();
            this.inner = new NonoRepeatWhen.RedoInnerSubscriber(this);
            this.once = new AtomicBoolean();
            this.processor = processor;
            this.source = source;
        }

        public void cancel() {
            SubscriptionHelper.cancel(this.s);
            this.inner.cancel();
        }

        public void onSubscribe(Subscription s) {
            SubscriptionHelper.replace(this.s, (Subscription)s);
        }

        public void onNext(Void t) {
        }

        public void onError(Throwable t) {
            this.active = false;
            if (this.getAndIncrement() == 0) {
                do {
                    if (SubscriptionHelper.isCancelled((Subscription)this.s.get())) {
                        return;
                    }
                    if (this.active) continue;
                    this.active = true;
                    this.inner.request(1L);
                    this.processor.onNext((Object)t);
                } while (this.decrementAndGet() != 0);
            }
        }

        public void onComplete() {
            this.inner.cancel();
            if (this.once.compareAndSet(false, true)) {
                this.actual.onComplete();
            }
        }

        @Override
        public void innerNext() {
            this.source.subscribe(this);
        }

        @Override
        public void innerError(Throwable ex) {
            SubscriptionHelper.cancel(this.s);
            if (this.once.compareAndSet(false, true)) {
                this.actual.onError(ex);
            } else {
                RxJavaPlugins.onError((Throwable)ex);
            }
        }

        @Override
        public void innerComplete() {
            SubscriptionHelper.cancel(this.s);
            if (this.once.compareAndSet(false, true)) {
                this.actual.onComplete();
            }
        }
    }
}

