/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloDelayPublisher<T>
extends Solo<T> {
    final Solo<T> source;
    final Publisher<?> other;

    SoloDelayPublisher(Solo<T> source, Publisher<?> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new DelaySubscriber<T>(s, this.other));
    }

    static final class DelaySubscriber<T>
    extends AtomicReference<Subscription>
    implements QueueSubscription<T>,
    Subscriber<T> {
        private static final long serialVersionUID = 511073038536312798L;
        final Subscriber<? super T> actual;
        final Publisher<?> other;
        Subscription s;
        T value;
        Throwable error;
        volatile boolean available;
        boolean outputFused;

        DelaySubscriber(Subscriber<? super T> actual, Publisher<?> other) {
            this.actual = actual;
            this.other = other;
        }

        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        public T poll() throws Exception {
            if (this.available) {
                T v = this.value;
                this.value = null;
                return v;
            }
            return null;
        }

        public boolean isEmpty() {
            return !this.available || this.value == null;
        }

        public void clear() {
            this.value = null;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
            SubscriptionHelper.cancel((AtomicReference)this);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            this.error = t;
            this.onComplete();
        }

        public void onComplete() {
            this.other.subscribe((Subscriber)new OtherSubscriber());
        }

        void run() {
            Subscriber<? super T> a = this.actual;
            Throwable ex = this.error;
            if (ex != null) {
                a.onError(ex);
            } else {
                if (this.outputFused) {
                    this.available = true;
                    a.onNext(null);
                } else {
                    T v = this.value;
                    this.value = null;
                    if (v != null) {
                        a.onNext(v);
                    }
                }
                a.onComplete();
            }
        }

        public boolean offer(T value) {
            throw new UnsupportedOperationException();
        }

        public boolean offer(T v1, T v2) {
            throw new UnsupportedOperationException();
        }

        boolean innerSubscribe(Subscription s) {
            return SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s);
        }

        void innerCancel() {
            SubscriptionHelper.cancel((AtomicReference)this);
        }

        void innerError(Throwable ex) {
            Throwable e = this.error;
            this.error = e == null ? ex : new CompositeException(new Throwable[]{e, ex});
            this.run();
        }

        final class OtherSubscriber
        implements Subscriber<Object> {
            boolean done;

            OtherSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (DelaySubscriber.this.innerSubscribe(s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(Object t) {
                SubscriptionHelper.cancel((AtomicReference)DelaySubscriber.this);
                this.onComplete();
            }

            public void onError(Throwable t) {
                if (this.done) {
                    RxJavaPlugins.onError((Throwable)t);
                } else {
                    DelaySubscriber.this.innerError(t);
                }
            }

            public void onComplete() {
                if (!this.done) {
                    this.done = true;
                    DelaySubscriber.this.run();
                }
            }
        }
    }
}

