/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloFlatMapSignal<T, R>
extends Solo<R> {
    final Solo<T> source;
    final Function<? super T, ? extends Solo<? extends R>> onSuccessMapper;
    final Function<? super Throwable, ? extends Solo<? extends R>> onErrorMapper;

    SoloFlatMapSignal(Solo<T> source, Function<? super T, ? extends Solo<? extends R>> onSuccessMapper, Function<? super Throwable, ? extends Solo<? extends R>> onErrorMapper) {
        this.source = source;
        this.onSuccessMapper = onSuccessMapper;
        this.onErrorMapper = onErrorMapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new FlatMapSignalSubscriber<T, R>(s, this.onSuccessMapper, this.onErrorMapper));
    }

    static final class FlatMapSignalSubscriber<T, R>
    extends DeferredScalarSubscription<R>
    implements Subscriber<T> {
        private static final long serialVersionUID = -7631998337002592538L;
        final Function<? super T, ? extends Solo<? extends R>> onSuccessMapper;
        final Function<? super Throwable, ? extends Solo<? extends R>> onErrorMapper;
        final NextSubscriber nextSubscriber;
        Subscription s;

        FlatMapSignalSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Solo<? extends R>> onSuccessMapper, Function<? super Throwable, ? extends Solo<? extends R>> onErrorMapper) {
            super(actual);
            this.onSuccessMapper = onSuccessMapper;
            this.onErrorMapper = onErrorMapper;
            this.nextSubscriber = new NextSubscriber();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            Solo sp;
            try {
                sp = (Solo)ObjectHelper.requireNonNull((Object)this.onSuccessMapper.apply(t), (String)"The onSuccessMapper returned a null Solo");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.actual.onError(ex);
                return;
            }
            sp.subscribe(this.nextSubscriber);
        }

        public void onError(Throwable t) {
            Solo sp;
            try {
                sp = (Solo)ObjectHelper.requireNonNull((Object)this.onErrorMapper.apply((Object)t), (String)"The onErrorMapper returned a null Solo");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.actual.onError(ex);
                return;
            }
            sp.subscribe(this.nextSubscriber);
        }

        public void onComplete() {
        }

        public void cancel() {
            super.cancel();
            this.s.cancel();
            SubscriptionHelper.cancel((AtomicReference)this.nextSubscriber);
        }

        void nextComplete() {
            this.complete(this.value);
        }

        final class NextSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<R> {
            private static final long serialVersionUID = 5161815655607865861L;

            NextSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(R t) {
                FlatMapSignalSubscriber.this.value = t;
            }

            public void onError(Throwable t) {
                FlatMapSignalSubscriber.this.actual.onError(t);
            }

            public void onComplete() {
                FlatMapSignalSubscriber.this.nextComplete();
            }
        }
    }
}

