/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import hu.akarnokd.rxjava2.util.SpscOneQueue;
import io.reactivex.Scheduler;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloObserveOn<T>
extends Solo<T> {
    final Solo<T> source;
    final Scheduler scheduler;

    SoloObserveOn(Solo<T> source, Scheduler scheduler) {
        this.source = source;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new ObserveOnSubscriber<T>(s, this.scheduler.createWorker()));
    }

    static final class ObserveOnSubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements Subscriber<T>,
    Runnable {
        private static final long serialVersionUID = -658564450611526565L;
        final Subscriber<? super T> actual;
        final Scheduler.Worker worker;
        Subscription s;
        volatile boolean done;
        Throwable error;
        SimpleQueue<T> queue;
        volatile boolean cancelled;
        volatile boolean requested;
        int sourceMode;
        boolean outputFused;

        ObserveOnSubscriber(Subscriber<? super T> actual, Scheduler.Worker worker) {
            this.actual = actual;
            this.worker = worker;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(7);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.actual.onSubscribe((Subscription)this);
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.actual.onSubscribe((Subscription)this);
                        s.request(Long.MAX_VALUE);
                        return;
                    }
                }
                this.queue = new SpscOneQueue();
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.sourceMode == 0) {
                this.queue.offer(t);
            }
            this.trySchedule();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.trySchedule();
        }

        public void onComplete() {
            this.done = true;
            this.trySchedule();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void clear() {
            this.queue.clear();
        }

        public T poll() throws Exception {
            return (T)this.queue.poll();
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                this.worker.dispose();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                this.requested = true;
                this.trySchedule();
            }
        }

        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        void trySchedule() {
            if (this.getAndIncrement() == 0) {
                this.worker.schedule((Runnable)this);
            }
        }

        @Override
        public void run() {
            SimpleQueue<T> q = this.queue;
            int missed = 1;
            do {
                if (this.cancelled) {
                    q.clear();
                    return;
                }
                boolean d = this.done;
                if (this.requested) {
                    if (this.outputFused) {
                        boolean empty = q.isEmpty();
                        if (!empty) {
                            this.actual.onNext(null);
                            empty = true;
                        }
                    } else {
                        boolean empty;
                        Object v;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            q.clear();
                            this.actual.onError(ex);
                            this.worker.dispose();
                            return;
                        }
                        boolean bl = empty = v == null;
                        if (!empty) {
                            this.actual.onNext(v);
                            empty = true;
                        }
                    }
                }
                if (!d) continue;
                Throwable ex = this.error;
                if (ex != null) {
                    this.actual.onError(ex);
                    this.worker.dispose();
                    return;
                }
                if (!q.isEmpty()) continue;
                this.actual.onComplete();
                this.worker.dispose();
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

