/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Scheduler;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableDebounceFirst<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final Publisher<T> source;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;

    FlowableDebounceFirst(Publisher<T> source, long timeout, TimeUnit unit, Scheduler scheduler) {
        this.source = source;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableDebounceFirst<T>(upstream, this.timeout, this.unit, this.scheduler);
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new DebounceFirstSubscriber<T>(s, this.timeout, this.unit, this.scheduler));
    }

    static final class DebounceFirstSubscriber<T>
    implements ConditionalSubscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final long timeout;
        final TimeUnit unit;
        final Scheduler scheduler;
        Subscription s;
        long timestamp;
        long gate;

        DebounceFirstSubscriber(Subscriber<? super T> actual, long timeout, TimeUnit unit, Scheduler scheduler) {
            this.actual = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.gate = this.scheduler.now(this.unit);
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            long now = this.scheduler.now(this.unit);
            long g = this.gate;
            this.gate = now + this.timeout;
            if (now < g) {
                return false;
            }
            this.actual.onNext(t);
            return true;
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

