/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableEvery<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final Publisher<T> source;
    final long keep;

    FlowableEvery(Publisher<T> source, long keep) {
        this.source = source;
        this.keep = keep;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new EverySubscriber<T>(s, this.keep));
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableEvery<T>(upstream, this.keep);
    }

    static final class EverySubscriber<T>
    implements Subscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final long keep;
        long index;
        Subscription s;

        EverySubscriber(Subscriber<? super T> actual, long keep) {
            this.actual = actual;
            this.keep = keep;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            long i = this.index + 1L;
            if (i == this.keep) {
                this.index = 0L;
                this.actual.onNext(t);
            } else {
                this.index = i;
            }
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                long u = BackpressureHelper.multiplyCap((long)n, (long)this.keep);
                this.s.request(u);
            }
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

