/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.FlowableTransformer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableRefCountTimeout<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final ConnectableFlowable<T> source;
    final int n;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    RefConnection connection;

    FlowableRefCountTimeout(ConnectableFlowable<T> source, int n, long timeout, TimeUnit unit, Scheduler scheduler) {
        this.source = source;
        this.n = n;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        if (upstream instanceof ConnectableFlowable) {
            return new FlowableRefCountTimeout<T>((ConnectableFlowable)upstream, this.n, this.timeout, this.unit, this.scheduler);
        }
        throw new IllegalArgumentException("This transformer requires an upstream ConnectableFlowable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subscribeActual(Subscriber<? super T> s) {
        block6: {
            RefConnection conn;
            boolean connect = false;
            FlowableRefCountTimeout flowableRefCountTimeout = this;
            synchronized (flowableRefCountTimeout) {
                long c;
                conn = this.connection;
                if (conn == null || conn.terminated) {
                    this.connection = conn = new RefConnection(this);
                }
                if ((c = conn.subscriberCount) == 0L && conn.timer != null) {
                    conn.timer.dispose();
                }
                conn.subscriberCount = c + 1L;
                if (!conn.connected && c + 1L == (long)this.n) {
                    connect = true;
                    conn.connected = true;
                }
            }
            this.source.subscribe(new RefCountSubscriber<T>(s, this, conn));
            if (!connect) break block6;
            this.source.connect((Consumer)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(RefConnection rc) {
        SequentialDisposable sd;
        FlowableRefCountTimeout flowableRefCountTimeout = this;
        synchronized (flowableRefCountTimeout) {
            long c;
            if (rc.terminated) {
                return;
            }
            rc.subscriberCount = c = rc.subscriberCount - 1L;
            if (c != 0L || !rc.connected) {
                return;
            }
            if (this.timeout == 0L) {
                this.timeout(rc);
                return;
            }
            sd = new SequentialDisposable();
            rc.timer = sd;
        }
        sd.replace(this.scheduler.scheduleDirect((Runnable)rc, this.timeout, this.unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminated(RefConnection rc) {
        FlowableRefCountTimeout flowableRefCountTimeout = this;
        synchronized (flowableRefCountTimeout) {
            if (!rc.terminated) {
                rc.terminated = true;
                if (this.source instanceof Disposable) {
                    ((Disposable)this.source).dispose();
                }
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeout(RefConnection rc) {
        FlowableRefCountTimeout flowableRefCountTimeout = this;
        synchronized (flowableRefCountTimeout) {
            if (rc.subscriberCount == 0L && rc == this.connection) {
                DisposableHelper.dispose((AtomicReference)rc);
                if (this.source instanceof Disposable) {
                    ((Disposable)this.source).dispose();
                }
                this.connection = null;
            }
        }
    }

    static final class RefCountSubscriber<T>
    extends AtomicBoolean
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -7419642935409022375L;
        final Subscriber<? super T> actual;
        final FlowableRefCountTimeout<T> parent;
        final RefConnection connection;
        Subscription upstream;

        RefCountSubscriber(Subscriber<? super T> actual, FlowableRefCountTimeout<T> parent, RefConnection connection) {
            this.actual = actual;
            this.parent = parent;
            this.connection = connection;
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.compareAndSet(false, true)) {
                this.parent.terminated(this.connection);
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.compareAndSet(false, true)) {
                this.parent.terminated(this.connection);
            }
            this.actual.onComplete();
        }

        public void request(long n) {
            this.upstream.request(n);
        }

        public void cancel() {
            this.upstream.cancel();
            if (this.compareAndSet(false, true)) {
                this.parent.cancel(this.connection);
            }
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }
    }

    static final class RefConnection
    extends AtomicReference<Disposable>
    implements Runnable,
    Consumer<Disposable> {
        private static final long serialVersionUID = -4552101107598366241L;
        final FlowableRefCountTimeout<?> parent;
        Disposable timer;
        long subscriberCount;
        boolean connected;
        boolean terminated;

        RefConnection(FlowableRefCountTimeout<?> parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            this.parent.timeout(this);
        }

        public void accept(Disposable t) throws Exception {
            DisposableHelper.replace((AtomicReference)this, (Disposable)t);
        }
    }
}

