/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.FlowableTransformer;
import io.reactivex.Scheduler;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableRequestObserveOn<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final Flowable<T> source;
    final Scheduler scheduler;

    FlowableRequestObserveOn(Flowable<T> source, Scheduler scheduler) {
        this.source = source;
        this.scheduler = scheduler;
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableRequestObserveOn<T>(upstream, this.scheduler);
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new RequestObserveOnSubscriber<T>(s, this.scheduler.createWorker()));
    }

    static final class RequestObserveOnSubscriber<T>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 3167152788131496136L;
        final Subscriber<? super T> actual;
        final Scheduler.Worker worker;
        final Runnable requestOne;
        Subscription upstream;
        volatile T item;
        Throwable error;
        volatile boolean done;
        long emitted;
        boolean terminated;

        RequestObserveOnSubscriber(Subscriber<? super T> actual, Scheduler.Worker worker) {
            this.actual = actual;
            this.worker = worker;
            this.requestOne = new Runnable(){

                @Override
                public void run() {
                    RequestObserveOnSubscriber.this.upstream.request(1L);
                }
            };
        }

        public void onSubscribe(Subscription s) {
            this.upstream = s;
            this.actual.onSubscribe((Subscription)this);
            this.worker.schedule(this.requestOne);
        }

        public void onNext(T t) {
            this.item = t;
            this.worker.schedule((Runnable)this);
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.worker.schedule((Runnable)this);
        }

        public void onComplete() {
            this.done = true;
            this.worker.schedule((Runnable)this);
        }

        @Override
        public void run() {
            if (this.terminated) {
                return;
            }
            while (true) {
                boolean empty;
                boolean d = this.done;
                T v = this.item;
                boolean bl = empty = v == null;
                if (d && empty) {
                    Throwable ex = this.error;
                    if (ex != null) {
                        this.actual.onError(ex);
                    } else {
                        this.actual.onComplete();
                    }
                    this.worker.dispose();
                    this.terminated = true;
                    return;
                }
                long e = this.emitted;
                if (empty || e == this.get()) break;
                this.item = null;
                this.actual.onNext(v);
                this.emitted = e + 1L;
                this.worker.schedule(this.requestOne);
            }
        }

        public void request(long n) {
            BackpressureHelper.add((AtomicLong)this, (long)n);
            this.worker.schedule((Runnable)this);
        }

        public void cancel() {
            this.upstream.cancel();
            this.worker.dispose();
            this.item = null;
        }
    }
}

