/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Flowable;
import io.reactivex.FlowableOperator;
import io.reactivex.FlowableTransformer;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableValve<T>
extends Flowable<T>
implements FlowableOperator<T, T>,
FlowableTransformer<T, T> {
    final Publisher<? extends T> source;
    final Publisher<Boolean> other;
    final boolean defaultOpen;
    final int bufferSize;

    FlowableValve(Publisher<? extends T> source, Publisher<Boolean> other, boolean defaultOpen, int bufferSize) {
        this.source = source;
        this.other = other;
        this.defaultOpen = defaultOpen;
        this.bufferSize = bufferSize;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(this.apply(s));
    }

    public Subscriber<? super T> apply(Subscriber<? super T> observer) {
        ValveMainSubscriber<? super T> parent = new ValveMainSubscriber<T>(observer, this.bufferSize, this.defaultOpen);
        observer.onSubscribe(parent);
        this.other.subscribe((Subscriber)parent.other);
        return parent;
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableValve<T>(upstream, this.other, this.defaultOpen, this.bufferSize);
    }

    static final class ValveMainSubscriber<T>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -2233734924340471378L;
        final Subscriber<? super T> actual;
        final AtomicReference<Subscription> s;
        final AtomicLong requested;
        final SimplePlainQueue<T> queue;
        final OtherSubscriber other;
        final AtomicThrowable error;
        volatile boolean done;
        volatile boolean gate;
        volatile boolean cancelled;

        ValveMainSubscriber(Subscriber<? super T> actual, int bufferSize, boolean defaultOpen) {
            this.actual = actual;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.gate = defaultOpen;
            this.other = new OtherSubscriber();
            this.requested = new AtomicLong();
            this.error = new AtomicThrowable();
            this.s = new AtomicReference();
        }

        public void onSubscribe(Subscription s) {
            SubscriptionHelper.deferredSetOnce(this.s, (AtomicLong)this.requested, (Subscription)s);
        }

        public void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        public void onError(Throwable t) {
            if (this.error.addThrowable(t)) {
                this.drain();
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.s, (AtomicLong)this.requested, (long)n);
        }

        public void cancel() {
            this.cancelled = true;
            SubscriptionHelper.cancel(this.s);
            SubscriptionHelper.cancel((AtomicReference)this.other);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SimplePlainQueue<T> q = this.queue;
            Subscriber<? super T> a = this.actual;
            AtomicThrowable error = this.error;
            while (true) {
                if (this.cancelled) {
                    q.clear();
                    return;
                }
                if (error.get() != null) {
                    Throwable ex = error.terminate();
                    q.clear();
                    SubscriptionHelper.cancel(this.s);
                    SubscriptionHelper.cancel((AtomicReference)this.other);
                    a.onError(ex);
                    return;
                }
                if (this.gate) {
                    boolean empty;
                    boolean d = this.done;
                    Object v = q.poll();
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        SubscriptionHelper.cancel((AtomicReference)this.other);
                        a.onComplete();
                        return;
                    }
                    if (!empty) {
                        a.onNext(v);
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void change(boolean state) {
            this.gate = state;
            if (state) {
                this.drain();
            }
        }

        void innerError(Throwable ex) {
            this.onError(ex);
        }

        void innerComplete() {
            this.innerError(new IllegalStateException("The valve source completed unexpectedly."));
        }

        final class OtherSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<Boolean> {
            private static final long serialVersionUID = -3076915855750118155L;

            OtherSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(Boolean t) {
                ValveMainSubscriber.this.change(t);
            }

            public void onError(Throwable t) {
                ValveMainSubscriber.this.innerError(t);
            }

            public void onComplete() {
                ValveMainSubscriber.this.innerComplete();
            }
        }
    }
}

