/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableFlatMapDrop<T, R>
extends Observable<R>
implements ObservableTransformer<T, R> {
    final Observable<T> source;
    final Function<? super T, ? extends ObservableSource<? extends R>> mapper;

    ObservableFlatMapDrop(Observable<T> source, Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    public ObservableSource<R> apply(Observable<T> upstream) {
        return new ObservableFlatMapDrop<T, R>(upstream, this.mapper);
    }

    protected void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new FlatMapDropObserver<T, R>(observer, this.mapper));
    }

    static final class FlatMapDropObserver<T, R>
    implements Observer<T>,
    Disposable {
        final Observer<? super R> downstream;
        final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
        final FlatMapDropInnerObserver innerObserver;
        final AtomicThrowable errors;
        final AtomicInteger done;
        Disposable upstream;
        volatile boolean active;

        FlatMapDropObserver(Observer<? super R> downstream, Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.innerObserver = new FlatMapDropInnerObserver();
            this.errors = new AtomicThrowable();
            this.done = new AtomicInteger(1);
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)this.upstream, (Disposable)d)) {
                this.upstream = d;
                this.downstream.onSubscribe((Disposable)this);
            }
        }

        public void onNext(T t) {
            if (!this.active) {
                ObservableSource o;
                try {
                    o = (ObservableSource)ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper returned a null ObservableSource");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.upstream.dispose();
                    this.onError(ex);
                    return;
                }
                this.active = true;
                this.done.incrementAndGet();
                o.subscribe((Observer)this.innerObserver);
            }
        }

        public void onError(Throwable e) {
            if (this.errors.addThrowable(e)) {
                this.onComplete();
            } else {
                RxJavaPlugins.onError((Throwable)e);
            }
        }

        public void onComplete() {
            if (this.done.decrementAndGet() == 0) {
                Throwable ex = this.errors.terminate();
                if (ex == null) {
                    this.downstream.onComplete();
                } else {
                    this.downstream.onError(ex);
                }
            }
        }

        public void dispose() {
            this.upstream.dispose();
            DisposableHelper.dispose((AtomicReference)this.innerObserver);
        }

        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        void innerNext(R item) {
            this.downstream.onNext(item);
        }

        void innerError(Throwable e) {
            if (this.errors.addThrowable(e)) {
                this.innerComplete();
            } else {
                RxJavaPlugins.onError((Throwable)e);
            }
        }

        void innerComplete() {
            this.active = false;
            if (this.done.decrementAndGet() == 0) {
                Throwable ex = this.errors.terminate();
                if (ex == null) {
                    this.downstream.onComplete();
                } else {
                    this.downstream.onError(ex);
                }
            }
        }

        final class FlatMapDropInnerObserver
        extends AtomicReference<Disposable>
        implements Observer<R> {
            private static final long serialVersionUID = -3707363807296094399L;

            FlatMapDropInnerObserver() {
            }

            public void onSubscribe(Disposable d) {
                DisposableHelper.replace((AtomicReference)this, (Disposable)d);
            }

            public void onNext(R t) {
                FlatMapDropObserver.this.innerNext(t);
            }

            public void onError(Throwable e) {
                FlatMapDropObserver.this.innerError(e);
            }

            public void onComplete() {
                FlatMapDropObserver.this.innerComplete();
            }
        }
    }
}

