/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.processors;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MulticastProcessor<T>
extends FlowableProcessor<T> {
    final AtomicInteger wip;
    final AtomicReference<Subscription> upstream;
    final AtomicReference<MulticastSubscription<T>[]> subscribers;
    final AtomicBoolean once;
    final int bufferSize;
    final int limit;
    final boolean refcount;
    volatile SimpleQueue<T> queue;
    volatile boolean done;
    volatile Throwable error;
    int consumed;
    int fusionMode;
    static final MulticastSubscription[] EMPTY = new MulticastSubscription[0];
    static final MulticastSubscription[] TERMINATED = new MulticastSubscription[0];

    public static <T> MulticastProcessor<T> create() {
        return new MulticastProcessor<T>(MulticastProcessor.bufferSize(), false);
    }

    public static <T> MulticastProcessor<T> create(boolean refCount) {
        return new MulticastProcessor<T>(MulticastProcessor.bufferSize(), refCount);
    }

    public static <T> MulticastProcessor<T> create(int bufferSize) {
        return new MulticastProcessor<T>(bufferSize, false);
    }

    public static <T> MulticastProcessor<T> create(int bufferSize, boolean refCount) {
        return new MulticastProcessor<T>(bufferSize, refCount);
    }

    MulticastProcessor(int bufferSize, boolean refCount) {
        this.bufferSize = bufferSize;
        this.limit = bufferSize - (bufferSize >> 2);
        this.wip = new AtomicInteger();
        this.subscribers = new AtomicReference<MulticastSubscription[]>(EMPTY);
        this.upstream = new AtomicReference();
        this.refcount = refCount;
        this.once = new AtomicBoolean();
    }

    public void start() {
        if (SubscriptionHelper.setOnce(this.upstream, (Subscription)EmptySubscription.INSTANCE)) {
            this.queue = new SpscArrayQueue(this.bufferSize);
        }
    }

    public void startUnbounded() {
        if (SubscriptionHelper.setOnce(this.upstream, (Subscription)EmptySubscription.INSTANCE)) {
            this.queue = new SpscLinkedArrayQueue(this.bufferSize);
        }
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this.upstream, (Subscription)s)) {
            if (s instanceof QueueSubscription) {
                QueueSubscription qs = (QueueSubscription)s;
                int m = qs.requestFusion(3);
                if (m == 1) {
                    this.fusionMode = m;
                    this.queue = qs;
                    this.done = true;
                    this.drain();
                    return;
                }
                if (m == 2) {
                    this.fusionMode = m;
                    this.queue = qs;
                    s.request((long)this.bufferSize);
                    return;
                }
            }
            this.queue = new SpscArrayQueue(this.bufferSize);
            s.request((long)this.bufferSize);
        }
    }

    public void onNext(T t) {
        if (this.once.get()) {
            return;
        }
        if (this.fusionMode == 0) {
            if (t == null) {
                throw new NullPointerException("t is null");
            }
            if (!this.queue.offer(t)) {
                SubscriptionHelper.cancel(this.upstream);
                this.onError((Throwable)new MissingBackpressureException());
                return;
            }
        }
        this.drain();
    }

    public boolean offer(T t) {
        if (this.once.get()) {
            return false;
        }
        if (t == null) {
            throw new NullPointerException("t is null");
        }
        if (this.fusionMode == 0 && this.queue.offer(t)) {
            this.drain();
            return true;
        }
        return false;
    }

    public void onError(Throwable t) {
        if (t == null) {
            throw new NullPointerException("t is null");
        }
        if (this.once.compareAndSet(false, true)) {
            this.error = t;
            this.done = true;
            this.drain();
        } else {
            RxJavaPlugins.onError((Throwable)t);
        }
    }

    public void onComplete() {
        if (this.once.compareAndSet(false, true)) {
            this.done = true;
            this.drain();
        }
    }

    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    public boolean hasThrowable() {
        return this.once.get() && this.error != null;
    }

    public boolean hasComplete() {
        return this.once.get() && this.error == null;
    }

    public Throwable getThrowable() {
        return this.once.get() ? this.error : null;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        MulticastSubscription<T> ms = new MulticastSubscription<T>(s, this);
        s.onSubscribe(ms);
        if (this.add(ms)) {
            if (ms.get() == Long.MIN_VALUE) {
                this.remove(ms);
            } else {
                this.drain();
            }
        } else {
            Throwable ex;
            if ((this.once.get() || !this.refcount) && (ex = this.error) != null) {
                s.onError(ex);
                return;
            }
            s.onComplete();
        }
    }

    boolean add(MulticastSubscription<T> inner) {
        MulticastSubscription[] b;
        MulticastSubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new MulticastSubscription[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void remove(MulticastSubscription<T> inner) {
        MulticastSubscription<T>[] a;
        int n;
        while ((n = (a = this.subscribers.get()).length) != 0) {
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) return;
            if (n == 1) {
                if (this.refcount) {
                    if (!this.subscribers.compareAndSet(a, TERMINATED)) continue;
                    SubscriptionHelper.cancel(this.upstream);
                    this.once.set(true);
                    return;
                }
                if (!this.subscribers.compareAndSet(a, EMPTY)) continue;
                return;
            }
            MulticastSubscription[] b = new MulticastSubscription[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
            if (this.subscribers.compareAndSet(a, b)) return;
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        AtomicReference<MulticastSubscription<T>[]> subs = this.subscribers;
        int c = this.consumed;
        int lim = this.limit;
        SimpleQueue<T> q = this.queue;
        int fm = this.fusionMode;
        block2: while (true) {
            int w;
            MulticastSubscription<T>[] as;
            int n;
            if ((n = (as = subs.get()).length) != 0) {
                MulticastSubscription<T>[] bs;
                long r = -1L;
                for (MulticastSubscription<T> a : as) {
                    long ra = a.get();
                    if (ra < 0L) continue;
                    r = r == -1L ? ra - a.emitted : Math.min(r, ra - a.emitted);
                }
                while (r > 0L) {
                    boolean empty;
                    Object v;
                    bs = subs.get();
                    if (bs == TERMINATED) {
                        q.clear();
                        return;
                    }
                    if (as != bs) continue block2;
                    boolean d = this.done;
                    try {
                        v = q != null ? q.poll() : null;
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        SubscriptionHelper.cancel(this.upstream);
                        d = true;
                        v = null;
                        this.error = ex;
                        this.done = true;
                    }
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        int n2;
                        Throwable ex = this.error;
                        if (ex != null) {
                            void var18_36;
                            MulticastSubscription[] multicastSubscriptionArray = subs.getAndSet(TERMINATED);
                            n2 = multicastSubscriptionArray.length;
                            boolean bl2 = false;
                            while (var18_36 < n2) {
                                MulticastSubscription inner = multicastSubscriptionArray[var18_36];
                                inner.onError(ex);
                                ++var18_36;
                            }
                        } else {
                            void var18_38;
                            MulticastSubscription[] multicastSubscriptionArray = subs.getAndSet(TERMINATED);
                            n2 = multicastSubscriptionArray.length;
                            boolean bl3 = false;
                            while (var18_38 < n2) {
                                MulticastSubscription inner = multicastSubscriptionArray[var18_38];
                                inner.onComplete();
                                ++var18_38;
                            }
                        }
                        return;
                    }
                    if (empty) break;
                    for (MulticastSubscription<Object> multicastSubscription : as) {
                        multicastSubscription.onNext(v);
                    }
                    --r;
                    if (fm == 1 || ++c != lim) continue;
                    c = 0;
                    this.upstream.get().request((long)lim);
                }
                if (r == 0L) {
                    bs = subs.get();
                    if (bs == TERMINATED) {
                        q.clear();
                        return;
                    }
                    if (as != bs) continue;
                    if (this.done && q.isEmpty()) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            for (MulticastSubscription inner : subs.getAndSet(TERMINATED)) {
                                inner.onError(ex);
                            }
                        } else {
                            for (MulticastSubscription inner : subs.getAndSet(TERMINATED)) {
                                inner.onComplete();
                            }
                        }
                        return;
                    }
                }
            }
            if ((w = this.wip.get()) == missed) {
                this.consumed = c;
                if ((missed = this.wip.addAndGet(-missed)) != 0) continue;
                break;
            }
            missed = w;
        }
    }

    static final class MulticastSubscription<T>
    extends AtomicLong
    implements Subscription {
        private static final long serialVersionUID = -363282618957264509L;
        final Subscriber<? super T> actual;
        final MulticastProcessor<T> parent;
        long emitted;

        MulticastSubscription(Subscriber<? super T> actual, MulticastProcessor<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                long r;
                while ((r = this.get()) != Long.MIN_VALUE && r != Long.MAX_VALUE) {
                    long u = r + n;
                    if (u < 0L) {
                        u = Long.MAX_VALUE;
                    }
                    if (!this.compareAndSet(r, u)) continue;
                    this.parent.drain();
                    break;
                }
            }
        }

        public void cancel() {
            if (this.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                this.parent.remove(this);
            }
        }

        void onNext(T t) {
            if (this.get() != Long.MIN_VALUE) {
                ++this.emitted;
                this.actual.onNext(t);
            }
        }

        void onError(Throwable t) {
            if (this.get() != Long.MIN_VALUE) {
                this.actual.onError(t);
            }
        }

        void onComplete() {
            if (this.get() != Long.MIN_VALUE) {
                this.actual.onComplete();
            }
        }
    }
}

