/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.interop;

import hu.akarnokd.rxjava2.interop.ZeroOneIterator;
import hu.akarnokd.rxjava2.subjects.CompletableSubject;
import io.reactivex.Completable;
import io.reactivex.functions.Function;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;

public final class CompletableInterop {
    private CompletableInterop() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Function<Completable, CompletionStage<T>> await() {
        return c -> {
            CompletableFuture cf = new CompletableFuture();
            c.subscribe(() -> cf.complete(null), cf::completeExceptionally);
            return cf;
        };
    }

    public static <T> Function<Completable, Stream<T>> toStream() {
        return c -> {
            ZeroOneIterator zoi = new ZeroOneIterator();
            c.subscribe(zoi);
            return ZeroOneIterator.toStream(zoi);
        };
    }

    public static Completable fromFuture(CompletionStage<?> future) {
        CompletableSubject cs = CompletableSubject.create();
        future.whenComplete((v, e) -> {
            if (e != null) {
                cs.onError(e);
            } else {
                cs.onComplete();
            }
        });
        return cs;
    }
}

