/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.interop;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableCollector<T, A, R>
extends Flowable<R> {
    final Publisher<T> source;
    final Collector<T, A, R> collector;

    FlowableCollector(Publisher<T> source, Collector<T, A, R> collector) {
        this.source = source;
        this.collector = collector;
    }

    protected void subscribeActual(Subscriber<? super R> s) {
        Function<A, R> finisher;
        BiConsumer<A, T> accumulator;
        A initialValue;
        try {
            initialValue = this.collector.supplier().get();
            accumulator = this.collector.accumulator();
            finisher = this.collector.finisher();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        this.source.subscribe(new CollectorSubscriber<T, A, R>(s, initialValue, accumulator, finisher));
    }

    static final class CollectorSubscriber<T, A, R>
    extends DeferredScalarSubscription<R>
    implements Subscriber<T> {
        private static final long serialVersionUID = 2129956429647866524L;
        final BiConsumer<A, T> accumulator;
        final Function<A, R> finisher;
        A intermediate;
        Subscription s;
        boolean done;

        public CollectorSubscriber(Subscriber<? super R> actual, A initialValue, BiConsumer<A, T> accumulator, Function<A, R> finisher) {
            super(actual);
            this.intermediate = initialValue;
            this.accumulator = accumulator;
            this.finisher = finisher;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (!this.done) {
                try {
                    this.accumulator.accept(this.intermediate, t);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.s.cancel();
                    this.onError(ex);
                }
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
            } else {
                this.done = true;
                this.intermediate = null;
                this.actual.onError(t);
            }
        }

        public void onComplete() {
            if (!this.done) {
                R r;
                try {
                    r = this.finisher.apply(this.intermediate);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.onError(ex);
                    return;
                }
                this.intermediate = null;
                this.complete(r);
            }
        }

        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

