/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.interop;

import hu.akarnokd.rxjava2.interop.FlowableCollector;
import hu.akarnokd.rxjava2.interop.FlowableMapOptional;
import hu.akarnokd.rxjava2.interop.ZeroOneIterator;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.functions.Function;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.AsyncProcessor;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collector;
import java.util.stream.Stream;

public final class FlowableInterop {
    private FlowableInterop() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Flowable<T> fromStream(Stream<T> stream) {
        return Flowable.fromIterable(() -> stream.iterator());
    }

    public static <T> Flowable<T> fromOptional(Optional<T> opt) {
        return opt.map(Flowable::just).orElse(Flowable.empty());
    }

    public static <T> Flowable<T> fromFuture(CompletionStage<T> cs) {
        AsyncProcessor ap = AsyncProcessor.create();
        cs.whenComplete((v, e) -> {
            if (e != null) {
                ap.onError(e);
            } else {
                ap.onNext(v);
                ap.onComplete();
            }
        });
        return ap;
    }

    public static <T, A, R> FlowableTransformer<T, R> collect(Collector<T, A, R> collector) {
        return f -> RxJavaPlugins.onAssembly(new FlowableCollector(f, collector));
    }

    public static <T> Function<Flowable<T>, CompletionStage<T>> first() {
        return f -> {
            CompletableFuture cf = new CompletableFuture();
            f.firstOrError().subscribe(cf::complete, cf::completeExceptionally);
            return cf;
        };
    }

    public static <T> Function<Flowable<T>, CompletionStage<T>> single() {
        return f -> {
            CompletableFuture cf = new CompletableFuture();
            f.singleOrError().subscribe(cf::complete, cf::completeExceptionally);
            return cf;
        };
    }

    public static <T> Function<Flowable<T>, CompletionStage<T>> last() {
        return f -> {
            CompletableFuture cf = new CompletableFuture();
            f.lastOrError().subscribe(cf::complete, cf::completeExceptionally);
            return cf;
        };
    }

    public static <T> Function<Flowable<T>, Stream<T>> toStream() {
        return f -> ZeroOneIterator.toStream(f.blockingIterable().iterator());
    }

    public static <T> Function<Flowable<T>, Optional<T>> firstElement() {
        return f -> Optional.ofNullable(f.blockingFirst(null));
    }

    public static <T> Function<Flowable<T>, Optional<T>> lastElement() {
        return f -> Optional.ofNullable(f.blockingLast(null));
    }

    public static <T, R> FlowableTransformer<T, R> flatMapStream(Function<? super T, ? extends Stream<R>> mapper) {
        return f -> f.flatMapIterable(v -> {
            Iterator it = ((Stream)mapper.apply(v)).iterator();
            return () -> it;
        });
    }

    public static <T, R> FlowableTransformer<T, R> mapOptional(Function<? super T, Optional<R>> mapper) {
        return f -> RxJavaPlugins.onAssembly(new FlowableMapOptional(f, mapper));
    }
}

