/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.interop;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.internal.subscribers.BasicFuseableSubscriber;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class FlowableMapOptional<T, R>
extends Flowable<R> {
    final Publisher<T> source;
    final Function<? super T, Optional<R>> mapper;

    FlowableMapOptional(Publisher<T> source, Function<? super T, Optional<R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    protected void subscribeActual(Subscriber<? super R> s) {
        if (s instanceof ConditionalSubscriber) {
            this.source.subscribe(new MapOptionalConditionalSubscriber<T, R>((ConditionalSubscriber)s, this.mapper));
        } else {
            this.source.subscribe(new MapOptionalSubscriber<T, R>(s, this.mapper));
        }
    }

    static final class MapOptionalConditionalSubscriber<T, R>
    extends BasicFuseableConditionalSubscriber<T, R>
    implements ConditionalSubscriber<T> {
        final Function<? super T, Optional<R>> mapper;

        public MapOptionalConditionalSubscriber(ConditionalSubscriber<? super R> actual, Function<? super T, Optional<R>> mapper) {
            super(actual);
            this.mapper = mapper;
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            Optional o;
            if (this.done) {
                return false;
            }
            if (this.sourceMode == 2) {
                return this.actual.tryOnNext(null);
            }
            try {
                o = (Optional)ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper returned a null Optional");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.fail(ex);
                return false;
            }
            if (o.isPresent()) {
                return this.actual.tryOnNext(o.get());
            }
            return false;
        }

        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        public R poll() throws Exception {
            Object t;
            while ((t = this.qs.poll()) != null) {
                Optional o = (Optional)this.mapper.apply(t);
                if (o.isPresent()) {
                    return (R)o.get();
                }
                if (this.sourceMode == 1) continue;
                this.s.request(1L);
            }
            return null;
        }
    }

    static final class MapOptionalSubscriber<T, R>
    extends BasicFuseableSubscriber<T, R>
    implements ConditionalSubscriber<T> {
        final Function<? super T, Optional<R>> mapper;

        public MapOptionalSubscriber(Subscriber<? super R> actual, Function<? super T, Optional<R>> mapper) {
            super(actual);
            this.mapper = mapper;
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        public boolean tryOnNext(T t) {
            Optional o;
            if (this.done) {
                return false;
            }
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
                return true;
            }
            try {
                o = (Optional)ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper returned a null Optional");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.fail(ex);
                return false;
            }
            if (o.isPresent()) {
                this.actual.onNext(o.get());
                return true;
            }
            return false;
        }

        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        public R poll() throws Exception {
            Object t;
            while ((t = this.qs.poll()) != null) {
                Optional o = (Optional)this.mapper.apply(t);
                if (o.isPresent()) {
                    return (R)o.get();
                }
                if (this.sourceMode == 1) continue;
                this.s.request(1L);
            }
            return null;
        }
    }
}

