/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.interop;

import hu.akarnokd.rxjava2.interop.MaybeMapOptional;
import hu.akarnokd.rxjava2.interop.ZeroOneIterator;
import hu.akarnokd.rxjava2.subjects.MaybeSubject;
import io.reactivex.Maybe;
import io.reactivex.MaybeTransformer;
import io.reactivex.functions.Function;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;

public final class MaybeInterop {
    private MaybeInterop() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Maybe<T> fromOptional(Optional<T> opt) {
        return opt.map(Maybe::just).orElse(Maybe.empty());
    }

    public static <T> Maybe<T> fromFuture(CompletionStage<T> cs) {
        MaybeSubject ms = MaybeSubject.create();
        cs.whenComplete((v, e) -> {
            if (e != null) {
                ms.onError(e);
            } else if (v != null) {
                ms.onSuccess(v);
            } else {
                ms.onComplete();
            }
        });
        return ms;
    }

    public static <T> Function<Maybe<T>, CompletionStage<T>> get() {
        return m -> {
            CompletableFuture cf = new CompletableFuture();
            m.subscribe(cf::complete, cf::completeExceptionally, () -> cf.complete(null));
            return cf;
        };
    }

    public static <T> Function<Maybe<T>, Stream<T>> toStream() {
        return m -> {
            ZeroOneIterator zoi = new ZeroOneIterator();
            m.subscribe(zoi);
            return ZeroOneIterator.toStream(zoi);
        };
    }

    public static <T> Function<Maybe<T>, Optional<T>> element() {
        return m -> Optional.ofNullable(m.blockingGet());
    }

    public static <T, R> MaybeTransformer<T, R> mapOptional(Function<? super T, Optional<R>> mapper) {
        return m -> RxJavaPlugins.onAssembly(new MaybeMapOptional(m, mapper));
    }
}

