/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.interop;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.Optional;

final class MaybeMapOptional<T, R>
extends Maybe<R> {
    final MaybeSource<T> source;
    final Function<? super T, Optional<R>> mapper;

    public MaybeMapOptional(MaybeSource<T> source, Function<? super T, Optional<R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    protected void subscribeActual(MaybeObserver<? super R> observer) {
        this.source.subscribe(new MapOptionalObserver<T, R>(observer, this.mapper));
    }

    static final class MapOptionalObserver<T, R>
    implements MaybeObserver<T>,
    Disposable {
        final MaybeObserver<? super R> actual;
        final Function<? super T, Optional<R>> mapper;
        Disposable d;

        public MapOptionalObserver(MaybeObserver<? super R> actual, Function<? super T, Optional<R>> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        public void dispose() {
            this.d.dispose();
        }

        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)this.d, (Disposable)d)) {
                this.d = d;
                this.actual.onSubscribe((Disposable)this);
            }
        }

        public void onSuccess(T value) {
            Optional v;
            try {
                v = (Optional)ObjectHelper.requireNonNull((Object)this.mapper.apply(value), (String)"The mapper returned a null Optional");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.actual.onError(ex);
                return;
            }
            if (v.isPresent()) {
                this.actual.onSuccess(v.get());
            } else {
                this.actual.onComplete();
            }
        }

        public void onError(Throwable e) {
            this.actual.onError(e);
        }

        public void onComplete() {
            this.actual.onComplete();
        }
    }
}

