/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.interop;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.observers.DeferredScalarDisposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;

final class ObservableCollector<T, A, R>
extends Observable<R> {
    final ObservableSource<T> source;
    final Collector<T, A, R> collector;

    ObservableCollector(ObservableSource<T> source, Collector<T, A, R> collector) {
        this.source = source;
        this.collector = collector;
    }

    protected void subscribeActual(Observer<? super R> s) {
        Function<A, R> finisher;
        BiConsumer<A, T> accumulator;
        A initialValue;
        try {
            initialValue = this.collector.supplier().get();
            accumulator = this.collector.accumulator();
            finisher = this.collector.finisher();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptyDisposable.error((Throwable)ex, s);
            return;
        }
        this.source.subscribe(new CollectorObserver<T, A, R>(s, initialValue, accumulator, finisher));
    }

    static final class CollectorObserver<T, A, R>
    extends DeferredScalarDisposable<R>
    implements Observer<T> {
        private static final long serialVersionUID = 2129956429647866524L;
        final BiConsumer<A, T> accumulator;
        final Function<A, R> finisher;
        A intermediate;
        Disposable d;
        boolean done;

        public CollectorObserver(Observer<? super R> actual, A initialValue, BiConsumer<A, T> accumulator, Function<A, R> finisher) {
            super(actual);
            this.intermediate = initialValue;
            this.accumulator = accumulator;
            this.finisher = finisher;
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)this.d, (Disposable)d)) {
                this.d = d;
                this.actual.onSubscribe((Disposable)this);
            }
        }

        public void onNext(T t) {
            if (!this.done) {
                try {
                    this.accumulator.accept(this.intermediate, t);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.d.dispose();
                    this.onError(ex);
                }
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
            } else {
                this.done = true;
                this.intermediate = null;
                this.actual.onError(t);
            }
        }

        public void onComplete() {
            if (!this.done) {
                R r;
                try {
                    r = this.finisher.apply(this.intermediate);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.onError(ex);
                    return;
                }
                this.intermediate = null;
                this.complete(r);
            }
        }

        public void dispose() {
            super.dispose();
            this.d.dispose();
        }
    }
}

