/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.interop;

import hu.akarnokd.rxjava2.interop.ObservableCollector;
import hu.akarnokd.rxjava2.interop.ObservableMapOptional;
import hu.akarnokd.rxjava2.interop.ZeroOneIterator;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.functions.Function;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.AsyncSubject;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collector;
import java.util.stream.Stream;

public final class ObservableInterop {
    private ObservableInterop() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Observable<T> fromStream(Stream<T> stream) {
        return Observable.fromIterable(() -> stream.iterator());
    }

    public static <T> Observable<T> fromOptional(Optional<T> opt) {
        return opt.map(Observable::just).orElse(Observable.empty());
    }

    public static <T> Observable<T> fromFuture(CompletionStage<T> cs) {
        AsyncSubject ap = AsyncSubject.create();
        cs.whenComplete((v, e) -> {
            if (e != null) {
                ap.onError(e);
            } else {
                ap.onNext(v);
                ap.onComplete();
            }
        });
        return ap;
    }

    public static <T, A, R> ObservableTransformer<T, R> collect(Collector<T, A, R> collector) {
        return f -> RxJavaPlugins.onAssembly(new ObservableCollector(f, collector));
    }

    public static <T> Function<Observable<T>, CompletionStage<T>> first() {
        return f -> {
            CompletableFuture cf = new CompletableFuture();
            f.firstOrError().subscribe(cf::complete, cf::completeExceptionally);
            return cf;
        };
    }

    public static <T> Function<Observable<T>, CompletionStage<T>> single() {
        return f -> {
            CompletableFuture cf = new CompletableFuture();
            f.singleOrError().subscribe(cf::complete, cf::completeExceptionally);
            return cf;
        };
    }

    public static <T> Function<Observable<T>, CompletionStage<T>> last() {
        return f -> {
            CompletableFuture cf = new CompletableFuture();
            f.lastOrError().subscribe(cf::complete, cf::completeExceptionally);
            return cf;
        };
    }

    public static <T> Function<Observable<T>, Stream<T>> toStream() {
        return f -> ZeroOneIterator.toStream(f.blockingIterable().iterator());
    }

    public static <T> Function<Observable<T>, Optional<T>> firstElement() {
        return o -> Optional.ofNullable(o.blockingFirst(null));
    }

    public static <T> Function<Observable<T>, Optional<T>> lastElement() {
        return o -> Optional.ofNullable(o.blockingLast(null));
    }

    public static <T, R> ObservableTransformer<T, R> mapOptional(Function<? super T, Optional<R>> mapper) {
        return f -> RxJavaPlugins.onAssembly(new ObservableMapOptional(f, mapper));
    }

    public static <T, R> ObservableTransformer<T, R> flatMapStream(Function<? super T, ? extends Stream<R>> mapper) {
        return o -> o.flatMapIterable(v -> {
            Iterator it = ((Stream)mapper.apply(v)).iterator();
            return () -> it;
        });
    }
}

