/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.interop;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.BasicFuseableObserver;
import java.util.Optional;

final class ObservableMapOptional<T, R>
extends Observable<R> {
    final ObservableSource<T> source;
    final Function<? super T, Optional<R>> mapper;

    ObservableMapOptional(ObservableSource<T> source, Function<? super T, Optional<R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    protected void subscribeActual(Observer<? super R> s) {
        this.source.subscribe(new MapOptionalObserver<T, R>(s, this.mapper));
    }

    static final class MapOptionalObserver<T, R>
    extends BasicFuseableObserver<T, R> {
        final Function<? super T, Optional<R>> mapper;

        public MapOptionalObserver(Observer<? super R> actual, Function<? super T, Optional<R>> mapper) {
            super(actual);
            this.mapper = mapper;
        }

        public void onNext(T t) {
            Optional o;
            if (this.done) {
                return;
            }
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
                return;
            }
            try {
                o = (Optional)ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper returned a null Optional");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.fail(ex);
                return;
            }
            if (o.isPresent()) {
                this.actual.onNext(o.get());
            }
        }

        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        public R poll() throws Exception {
            Object t;
            Optional o;
            do {
                if ((t = this.qs.poll()) != null) continue;
                return null;
            } while (!(o = (Optional)this.mapper.apply(t)).isPresent());
            return (R)o.get();
        }
    }
}

