/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.interop;

import io.reactivex.CompletableObserver;
import io.reactivex.MaybeObserver;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class ZeroOneIterator<T>
extends CountDownLatch
implements Iterator<T>,
Disposable,
MaybeObserver<T>,
SingleObserver<T>,
CompletableObserver {
    T value;
    Throwable error;
    Disposable d;
    volatile boolean disposed;

    ZeroOneIterator() {
        super(1);
    }

    @Override
    public boolean hasNext() {
        Throwable ex;
        if (this.getCount() != 0L) {
            try {
                this.await();
            }
            catch (InterruptedException ex2) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow((Throwable)ex2);
            }
        }
        if ((ex = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow((Throwable)ex);
        }
        return this.value != null;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T v = this.value;
            this.value = null;
            return v;
        }
        throw new NoSuchElementException();
    }

    public void onSubscribe(Disposable d) {
        if (DisposableHelper.validate((Disposable)this.d, (Disposable)d)) {
            this.d = d;
            if (this.disposed) {
                d.dispose();
            }
        }
    }

    public void onSuccess(T value) {
        this.value = value;
        this.countDown();
    }

    public void onError(Throwable e) {
        this.error = e;
        this.countDown();
    }

    public void onComplete() {
        this.countDown();
    }

    public void dispose() {
        this.disposed = true;
        Disposable d = this.d;
        if (d != null) {
            d.dispose();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public static <T> Stream<T> toStream(Iterator<T> it) {
        Stream<T> s = StreamSupport.stream(Spliterators.spliterator(it, 0L, 0), false);
        return (Stream)s.onClose(() -> ((Disposable)it).dispose());
    }
}

