/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.interop;

import hu.akarnokd.rxjava2.interop.RsToFlowSubscription;
import io.reactivex.processors.FlowableProcessor;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableProcessorFromFlowProcessor<T>
extends FlowableProcessor<T> {
    final Flow.Processor<T, T> actual;
    volatile int subscribers;
    static final VarHandle SUBSCRIBERS;
    volatile boolean done;
    Throwable error;

    FlowableProcessorFromFlowProcessor(Flow.Processor<T, T> actual) {
        this.actual = actual;
    }

    public boolean hasSubscribers() {
        return this.subscribers != 0;
    }

    public boolean hasThrowable() {
        return this.done && this.error != null;
    }

    public boolean hasComplete() {
        return this.done && this.error == null;
    }

    public Throwable getThrowable() {
        return this.done ? this.error : null;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        SUBSCRIBERS.getAndAdd(this, 1);
        this.actual.subscribe(new FlowSubscriber(s));
    }

    public void onSubscribe(Subscription s) {
        this.actual.onSubscribe(new RsToFlowSubscription(s));
    }

    public void onNext(T t) {
        this.actual.onNext(t);
    }

    public void onError(Throwable t) {
        this.error = t;
        this.done = true;
        this.actual.onError(t);
    }

    public void onComplete() {
        this.done = true;
        this.actual.onComplete();
    }

    void decrement() {
        SUBSCRIBERS.getAndAdd(this, -1);
    }

    static {
        try {
            SUBSCRIBERS = MethodHandles.lookup().in(FlowableProcessorFromFlowProcessor.class).findVarHandle(FlowableProcessorFromFlowProcessor.class, "subscribers", Integer.TYPE);
        }
        catch (Exception ex) {
            throw new InternalError(ex);
        }
    }

    final class FlowSubscriber
    extends AtomicBoolean
    implements Flow.Subscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        Flow.Subscription s;

        FlowSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.s = subscription;
            this.actual.onSubscribe((Subscription)this);
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.compareAndSet(false, true)) {
                FlowableProcessorFromFlowProcessor.this.decrement();
            }
            this.actual.onError(throwable);
        }

        @Override
        public void onComplete() {
            if (this.compareAndSet(false, true)) {
                FlowableProcessorFromFlowProcessor.this.decrement();
            }
            this.actual.onComplete();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            if (this.compareAndSet(false, true)) {
                FlowableProcessorFromFlowProcessor.this.decrement();
                this.s.cancel();
            }
        }
    }
}

