/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.swing;

import hu.akarnokd.rxjava2.swing.RxSwingPlugins;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.util.OpenHashSet;
import io.reactivex.plugins.RxJavaPlugins;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Timer;

final class AsyncSwingScheduler
extends Scheduler {
    static final Scheduler INSTANCE = new AsyncSwingScheduler();

    AsyncSwingScheduler() {
    }

    public Disposable scheduleDirect(Runnable run) {
        DirectTask dt = new DirectTask(RxSwingPlugins.onSchedule(run));
        EventQueue.invokeLater(dt);
        return dt;
    }

    public Disposable scheduleDirect(Runnable run, long delay, TimeUnit unit) {
        DirectTimedTask dtt = new DirectTimedTask(RxSwingPlugins.onSchedule(run), (int)unit.toMillis(delay), (int)Math.max(0L, unit.toMillis(delay)), false);
        dtt.start();
        return dtt;
    }

    public Disposable schedulePeriodicallyDirect(Runnable run, long initialDelay, long period, TimeUnit unit) {
        DirectTimedTask dtt = new DirectTimedTask(RxSwingPlugins.onSchedule(run), (int)unit.toMillis(initialDelay), (int)Math.max(0L, unit.toMillis(period)), true);
        dtt.start();
        return dtt;
    }

    public Scheduler.Worker createWorker() {
        return new AsyncSwingWorker();
    }

    static final class DirectTimedTask
    extends Timer
    implements ActionListener,
    Disposable {
        private static final long serialVersionUID = 1146820542834025296L;
        final boolean periodic;
        Runnable run;

        DirectTimedTask(Runnable run, int initialDelayMillis, int periodMillis, boolean periodic) {
            super(0, null);
            this.run = run;
            this.periodic = periodic;
            this.setInitialDelay(initialDelayMillis);
            this.setDelay(periodMillis);
            this.addActionListener(this);
        }

        public void dispose() {
            this.run = null;
            this.stop();
        }

        public boolean isDisposed() {
            return this.run == null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable r = this.run;
            if (r != null) {
                try {
                    r.run();
                }
                catch (Throwable ex) {
                    this.run = null;
                    this.stop();
                    Exceptions.throwIfFatal((Throwable)ex);
                    RxJavaPlugins.onError((Throwable)ex);
                    return;
                }
                if (!this.periodic) {
                    this.run = null;
                    this.stop();
                }
            }
        }
    }

    static final class DirectTask
    extends AtomicReference<Runnable>
    implements Runnable,
    Disposable {
        private static final long serialVersionUID = -4645934389976373118L;

        DirectTask(Runnable run) {
            this.lazySet(run);
        }

        @Override
        public void run() {
            Runnable r = (Runnable)this.get();
            if (r != null && this.compareAndSet(r, null)) {
                try {
                    r.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    RxJavaPlugins.onError((Throwable)ex);
                }
            }
        }

        public void dispose() {
            this.getAndSet(null);
        }

        public boolean isDisposed() {
            return this.get() == null;
        }
    }

    static final class AsyncSwingWorker
    extends Scheduler.Worker {
        volatile boolean disposed;
        OpenHashSet<Disposable> tasks = new OpenHashSet();

        AsyncSwingWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            if (!this.disposed) {
                Object[] keys;
                OpenHashSet<Disposable> set;
                AsyncSwingWorker asyncSwingWorker = this;
                synchronized (asyncSwingWorker) {
                    if (this.disposed) {
                        return;
                    }
                    set = this.tasks;
                    this.tasks = null;
                    this.disposed = true;
                }
                for (Object o : keys = set.keys()) {
                    if (!(o instanceof Disposable)) continue;
                    ((Disposable)o).dispose();
                }
            }
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(Disposable d) {
            if (!this.disposed) {
                AsyncSwingWorker asyncSwingWorker = this;
                synchronized (asyncSwingWorker) {
                    if (this.disposed) {
                        return;
                    }
                    this.tasks.remove((Object)d);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(Disposable d) {
            if (!this.disposed) {
                AsyncSwingWorker asyncSwingWorker = this;
                synchronized (asyncSwingWorker) {
                    if (!this.disposed) {
                        this.tasks.add((Object)d);
                        return true;
                    }
                }
            }
            return false;
        }

        public Disposable schedule(Runnable run) {
            WorkerTask wt = new WorkerTask(RxSwingPlugins.onSchedule(run));
            if (this.add(wt)) {
                EventQueue.invokeLater(wt);
                return wt;
            }
            return EmptyDisposable.INSTANCE;
        }

        public Disposable schedule(Runnable run, long delay, TimeUnit unit) {
            WorkerTimedTask wtt = new WorkerTimedTask(RxSwingPlugins.onSchedule(run), (int)unit.toMillis(delay), (int)Math.max(0L, unit.toMillis(delay)), false);
            if (this.add(wtt)) {
                wtt.start();
                return wtt;
            }
            return EmptyDisposable.INSTANCE;
        }

        public Disposable schedulePeriodically(Runnable run, long initialDelay, long period, TimeUnit unit) {
            WorkerTimedTask wtt = new WorkerTimedTask(RxSwingPlugins.onSchedule(run), (int)unit.toMillis(initialDelay), (int)Math.max(0L, unit.toMillis(period)), true);
            if (this.add(wtt)) {
                wtt.start();
                return wtt;
            }
            return EmptyDisposable.INSTANCE;
        }

        final class WorkerTimedTask
        extends Timer
        implements ActionListener,
        Disposable {
            private static final long serialVersionUID = 1146820542834025296L;
            final boolean periodic;
            Runnable run;

            WorkerTimedTask(Runnable run, int initialDelayMillis, int periodMillis, boolean periodic) {
                super(0, null);
                this.run = run;
                this.periodic = periodic;
                this.setInitialDelay(initialDelayMillis);
                this.setDelay(periodMillis);
                this.addActionListener(this);
            }

            public void dispose() {
                this.run = null;
                this.stop();
                AsyncSwingWorker.this.remove(this);
            }

            public boolean isDisposed() {
                return this.run == null;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Runnable r = this.run;
                if (r != null) {
                    try {
                        r.run();
                    }
                    catch (Throwable ex) {
                        this.run = null;
                        this.stop();
                        AsyncSwingWorker.this.remove(this);
                        Exceptions.throwIfFatal((Throwable)ex);
                        RxJavaPlugins.onError((Throwable)ex);
                        return;
                    }
                    if (!this.periodic) {
                        this.run = null;
                        this.stop();
                        AsyncSwingWorker.this.remove(this);
                    }
                }
            }
        }

        final class WorkerTask
        extends AtomicReference<Runnable>
        implements Runnable,
        Disposable {
            private static final long serialVersionUID = 3954858753004137205L;

            WorkerTask(Runnable run) {
                this.lazySet(run);
            }

            public void dispose() {
                if (this.getAndSet(null) != null) {
                    AsyncSwingWorker.this.remove(this);
                }
            }

            public boolean isDisposed() {
                return this.get() == null;
            }

            @Override
            public void run() {
                Runnable r = (Runnable)this.get();
                if (r != null && this.compareAndSet(r, null)) {
                    try {
                        try {
                            r.run();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            RxJavaPlugins.onError((Throwable)ex);
                        }
                    }
                    finally {
                        AsyncSwingWorker.this.remove(this);
                    }
                }
            }
        }
    }
}

