/*
 * Decompiled with CFR 0.152.
 */
package com.github.akunzai.log4j;

import com.github.akunzai.log4j.SendGridManager;
import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.HtmlLayout;
import org.apache.logging.log4j.core.util.Booleans;

@Plugin(name="SendGrid", category="Core", elementType="appender", printObject=true)
public class SendGridAppender
extends AbstractAppender {
    final SendGridManager manager;
    private static final int DEFAULT_BUFFER_SIZE = 512;

    private SendGridAppender(String name, Filter filter, Layout<? extends Serializable> layout, SendGridManager manager, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
        this.manager = manager;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static SendGridAppender createAppender(@PluginConfiguration Configuration config, @PluginAttribute(value="name") @Required String name, @PluginAttribute(value="to") String to, @PluginAttribute(value="cc") String cc, @PluginAttribute(value="bcc") String bcc, @PluginAttribute(value="from") String from, @PluginAttribute(value="replyTo") String replyTo, @PluginAttribute(value="subject") String subject, @PluginAttribute(value="host") String host, @PluginAttribute(value="apiKey", sensitive=true) String apiKey, @PluginAttribute(value="sandboxMode") String sandboxMode, @PluginAttribute(value="bufferSize") String bufferSize, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="ignoreExceptions") String ignore) {
        Configuration configuration;
        SendGridManager manager;
        if (name == null || name.isEmpty()) {
            LOGGER.error("No name provided for SendGridAppender");
            return null;
        }
        if (layout == null) {
            layout = HtmlLayout.createDefaultLayout();
        }
        if (filter == null) {
            filter = ThresholdFilter.createFilter(null, null, null);
        }
        if ((manager = SendGridManager.getSendGridManager(configuration = config != null ? config : new DefaultConfiguration(), to, cc, bcc, from, replyTo, subject, host, apiKey, Boolean.parseBoolean(sandboxMode), bufferSize == null ? 512 : Integer.parseInt(bufferSize), null)) == null) {
            return null;
        }
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        return new SendGridAppender(name, filter, (Layout<? extends Serializable>)layout, manager, ignoreExceptions, null);
    }

    public boolean isFiltered(LogEvent event) {
        boolean filtered = super.isFiltered(event);
        if (filtered) {
            this.manager.add(event);
        }
        return filtered;
    }

    public void append(LogEvent event) {
        this.manager.sendEvents(this.getLayout(), event);
    }

    public static class Builder
    extends AbstractAppender.Builder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<SendGridAppender> {
        @PluginBuilderAttribute
        private String to;
        @PluginBuilderAttribute
        private String cc;
        @PluginBuilderAttribute
        private String bcc;
        @PluginBuilderAttribute
        private String from;
        @PluginBuilderAttribute
        private String replyTo;
        @PluginBuilderAttribute
        private String subject;
        @PluginBuilderAttribute
        private String host;
        @PluginBuilderAttribute(sensitive=true)
        private String apiKey;
        @PluginBuilderAttribute
        private boolean sandboxMode;
        @PluginBuilderAttribute
        private int bufferSize = 512;
        private ManagerFactory<SendGridManager, SendGridManager.FactoryData> factory;

        public Builder setTo(String to) {
            this.to = to;
            return this;
        }

        public Builder setCc(String cc) {
            this.cc = cc;
            return this;
        }

        public Builder setBcc(String bcc) {
            this.bcc = bcc;
            return this;
        }

        public Builder setFrom(String from) {
            this.from = from;
            return this;
        }

        public Builder setReplyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public Builder setSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder setSandboxMode(boolean sandboxMode) {
            this.sandboxMode = sandboxMode;
            return this;
        }

        public Builder setFactory(ManagerFactory<SendGridManager, SendGridManager.FactoryData> factory) {
            this.factory = factory;
            return this;
        }

        public Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder setLayout(Layout<? extends Serializable> layout) {
            return (Builder)super.setLayout(layout);
        }

        public Builder setFilter(Filter filter) {
            return (Builder)super.setFilter(filter);
        }

        public SendGridAppender build() {
            if (this.getLayout() == null) {
                this.setLayout((Layout)HtmlLayout.createDefaultLayout());
            }
            if (this.getFilter() == null) {
                this.setFilter((Filter)ThresholdFilter.createFilter(null, null, null));
            }
            Configuration configuration = this.getConfiguration();
            SendGridManager manager = SendGridManager.getSendGridManager(configuration, this.to, this.cc, this.bcc, this.from, this.replyTo, this.subject, this.host, this.apiKey, this.sandboxMode, this.bufferSize, this.factory);
            return new SendGridAppender(this.getName(), this.getFilter(), this.getLayout(), manager, this.isIgnoreExceptions(), this.getPropertyArray());
        }
    }
}

