/*
 * Decompiled with CFR 0.152.
 */
package com.github.akunzai.log4j;

import com.github.akunzai.log4j.SendGridMessageBuilder;
import com.sendgrid.Method;
import com.sendgrid.Request;
import com.sendgrid.SendGrid;
import com.sendgrid.helpers.mail.Mail;
import com.sendgrid.helpers.mail.objects.Content;
import com.sendgrid.helpers.mail.objects.MailSettings;
import com.sendgrid.helpers.mail.objects.Setting;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.mail.Message;
import javax.mail.internet.AddressException;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.HtmlLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.CyclicBuffer;
import org.apache.logging.log4j.core.util.NameUtil;
import org.apache.logging.log4j.message.ReusableMessage;

class SendGridManager
extends AbstractManager {
    private static final SendGridManagerFactory FACTORY = new SendGridManagerFactory();
    private static final MailSettings SANDBOX_MAIL_SETTINGS;
    final SendGrid sendGrid;
    private final CyclicBuffer<LogEvent> buffer;
    private final FactoryData data;

    SendGridManager(String name, SendGrid sendGrid, FactoryData data) {
        super(null, name);
        this.sendGrid = sendGrid;
        this.data = data;
        this.buffer = new CyclicBuffer(LogEvent.class, data.numElements);
    }

    static SendGridManager getSendGridManager(Configuration config, String to, String cc, String bcc, String from, String replyTo, String subject, String host, String apiKey, boolean sandboxMode, int numElements, ManagerFactory<SendGridManager, FactoryData> factory) {
        String name = "SendGrid:" + NameUtil.md5((String)(host + ':' + apiKey));
        AbstractStringLayout.Serializer subjectSerializer = PatternLayout.newSerializerBuilder().setConfiguration(config).setPattern(subject).build();
        return (SendGridManager)SendGridManager.getManager((String)name, factory == null ? FACTORY : factory, (Object)new FactoryData(to, cc, bcc, from, replyTo, subjectSerializer, host, apiKey, sandboxMode, numElements));
    }

    void add(LogEvent event) {
        if (event instanceof Log4jLogEvent && event.getMessage() instanceof ReusableMessage) {
            ((Log4jLogEvent)event).makeMessageImmutable();
        } else if (event instanceof MutableLogEvent) {
            event = ((MutableLogEvent)event).createMemento();
        }
        this.buffer.add((Object)event);
    }

    void sendEvents(Layout<?> layout, LogEvent appendEvent) {
        try {
            LogEvent[] priorEvents;
            Mail message = this.createMailMessage(appendEvent);
            Content content = new Content();
            if (layout instanceof HtmlLayout) {
                content.setType("text/html");
            } else {
                content.setType("text/plain");
            }
            StringBuilder stringBuilder = new StringBuilder();
            byte[] header = layout.getHeader();
            if (header != null) {
                stringBuilder.append(new String(header, StandardCharsets.UTF_8));
            }
            for (LogEvent priorEvent : priorEvents = (LogEvent[])this.buffer.removeAll()) {
                stringBuilder.append(layout.toSerializable(priorEvent));
            }
            stringBuilder.append(layout.toSerializable(appendEvent));
            byte[] footer = layout.getFooter();
            if (footer != null) {
                stringBuilder.append(new String(footer, StandardCharsets.UTF_8));
            }
            content.setValue(stringBuilder.toString());
            message.addContent(content);
            Request request = new Request();
            request.setMethod(Method.POST);
            request.setEndpoint("mail/send");
            request.setBody(message.build());
            this.sendGrid.api(request);
        }
        catch (IOException | AddressException e) {
            this.logError("Caught exception while sending e-mail notification.", e);
            throw new LoggingException("Error occurred while sending email", e);
        }
    }

    private Mail createMailMessage(LogEvent appendEvent) throws AddressException {
        Mail message = new SendGridMessageBuilder().setFrom(this.data.from).setReplyTo(this.data.replyTo).setRecipients(Message.RecipientType.TO, this.data.to).setRecipients(Message.RecipientType.CC, this.data.cc).setRecipients(Message.RecipientType.BCC, this.data.bcc).setSubject(this.data.subject.toSerializable(appendEvent)).build();
        if (this.data.sandboxMode) {
            message.setMailSettings(SANDBOX_MAIL_SETTINGS);
        }
        return message;
    }

    static {
        Setting setting = new Setting();
        setting.setEnable(true);
        SANDBOX_MAIL_SETTINGS = new MailSettings();
        SANDBOX_MAIL_SETTINGS.setSandboxMode(setting);
    }

    static class SendGridManagerFactory
    implements ManagerFactory<SendGridManager, FactoryData> {
        SendGridManagerFactory() {
        }

        public SendGridManager createManager(String name, FactoryData data) {
            SendGrid sendGrid = new SendGrid(data.apiKey);
            if (data.host != null && !data.host.isEmpty()) {
                sendGrid.setHost(data.host);
            }
            return new SendGridManager(name, sendGrid, data);
        }
    }

    static class FactoryData {
        final String to;
        final String cc;
        final String bcc;
        final String from;
        final String replyTo;
        final AbstractStringLayout.Serializer subject;
        final String host;
        final String apiKey;
        final boolean sandboxMode;
        final int numElements;

        FactoryData(String to, String cc, String bcc, String from, String replyTo, AbstractStringLayout.Serializer subject, String host, String apiKey, boolean sandboxMode, int numElements) {
            this.to = to;
            this.cc = cc;
            this.bcc = bcc;
            this.from = from;
            this.replyTo = replyTo;
            this.subject = subject;
            this.host = host;
            this.apiKey = apiKey;
            this.sandboxMode = sandboxMode;
            this.numElements = numElements;
        }
    }
}

