/*
 * Decompiled with CFR 0.152.
 */
package com.github.akunzai.log4j;

import com.sendgrid.helpers.mail.Mail;
import com.sendgrid.helpers.mail.objects.Email;
import com.sendgrid.helpers.mail.objects.Personalization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.mail.Message;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.logging.log4j.core.util.Builder;

public class SendGridMessageBuilder
implements Builder<Mail> {
    private final Mail message = new Mail();

    public SendGridMessageBuilder setFrom(String from) throws AddressException {
        Email email = SendGridMessageBuilder.parseEmail(from);
        if (email != null) {
            this.message.setFrom(email);
        } else {
            InternetAddress address = InternetAddress.getLocalAddress(null);
            if (address != null) {
                if (address.getPersonal() == null || address.getPersonal().isEmpty()) {
                    this.message.setFrom(new Email(address.getAddress()));
                } else {
                    this.message.setFrom(new Email(address.getAddress(), address.getPersonal()));
                }
            }
        }
        return this;
    }

    public SendGridMessageBuilder setReplyTo(String replyTo) throws AddressException {
        Email email = SendGridMessageBuilder.parseEmail(replyTo);
        if (email != null) {
            this.message.setReplyTo(email);
        }
        return this;
    }

    public SendGridMessageBuilder setRecipients(Message.RecipientType recipientType, String recipients) throws AddressException {
        List personalizationList = this.message.getPersonalization();
        Personalization personalization = personalizationList == null ? new Personalization() : (Personalization)personalizationList.get(0);
        Collection<Email> emails = SendGridMessageBuilder.parseEmails(recipients);
        if (recipientType == Message.RecipientType.TO) {
            for (Email email : emails) {
                personalization.addTo(email);
            }
        } else if (recipientType == Message.RecipientType.CC) {
            for (Email email : emails) {
                personalization.addCc(email);
            }
        } else if (recipientType == Message.RecipientType.BCC) {
            for (Email email : emails) {
                personalization.addBcc(email);
            }
        }
        if (personalizationList == null) {
            this.message.addPersonalization(personalization);
        }
        return this;
    }

    public SendGridMessageBuilder setSubject(String subject) {
        if (subject != null) {
            this.message.setSubject(subject);
        }
        return this;
    }

    public Mail build() {
        return this.message;
    }

    private static Email parseEmail(String email) throws AddressException {
        if (email == null || email.isEmpty()) {
            return null;
        }
        InternetAddress address = new InternetAddress(email);
        if (address.getPersonal() == null || address.getPersonal().isEmpty()) {
            return new Email(address.getAddress());
        }
        return new Email(address.getAddress(), address.getPersonal());
    }

    private static Collection<Email> parseEmails(String email) throws AddressException {
        if (email == null || email.isEmpty()) {
            return Collections.emptySet();
        }
        InternetAddress[] addresses = InternetAddress.parse((String)email, (boolean)true);
        ArrayList<Email> emails = new ArrayList<Email>();
        for (InternetAddress address : addresses) {
            if (address.getPersonal() == null || address.getPersonal().isEmpty()) {
                emails.add(new Email(address.getAddress()));
                continue;
            }
            emails.add(new Email(address.getAddress(), address.getPersonal()));
        }
        return Collections.unmodifiableList(emails);
    }
}

