/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CircularArray<T>
implements Iterable<T> {
    private final int length;
    private final T[] array;
    private final Comparator<T> arrayComparator;
    private int size = 0;
    private int pointer = 0;
    private static final ThreadLocal<StringBuilder> STRING_BULDER = new ThreadLocal<StringBuilder>(){

        @Override
        protected final StringBuilder initialValue() {
            return new StringBuilder();
        }
    };

    public CircularArray(int length, Comparator<T> arrayComparator) {
        this.length = length;
        this.array = new Object[length];
        this.arrayComparator = arrayComparator;
    }

    public void addItem(T item) {
        if (this.pointer == this.length) {
            this.pointer = 0;
        }
        this.array[this.pointer++] = item;
        if (this.size < this.length) {
            ++this.size;
        }
    }

    public int searchItem(T item) {
        int index = Arrays.binarySearch(this.array, this.pointer, this.size, item, this.arrayComparator);
        if (index < 0) {
            index = Arrays.binarySearch(this.array, 0, this.pointer, item, this.arrayComparator);
        }
        return index;
    }

    public List<T> getLastItems(T item) {
        ArrayList lastItems = new ArrayList(this.size);
        int searchedItemIndex = this.searchItem(item);
        LastItemsIterator iterator = new LastItemsIterator(searchedItemIndex);
        while (iterator.hasNext()) {
            lastItems.add(iterator.next());
        }
        return lastItems;
    }

    public int size() {
        return this.size;
    }

    public Iterator<T> plainIterator() {
        return new PlainIterator();
    }

    @Override
    public Iterator<T> iterator() {
        return new LastItemsIterator();
    }

    public Iterator<T> iterator(int startIndex) {
        return new LastItemsIterator(startIndex);
    }

    public String toString() {
        StringBuilder valuesBuilder = STRING_BULDER.get();
        valuesBuilder.setLength(0);
        valuesBuilder.append('[');
        if (this.size > 0) {
            for (int i = 0; i < this.size; ++i) {
                valuesBuilder.append(' ').append(this.array[i].toString()).append(", ");
            }
            valuesBuilder.delete(valuesBuilder.length() - 2, valuesBuilder.length() - 1);
        }
        valuesBuilder.append(']');
        return valuesBuilder.toString();
    }

    private class LastItemsIterator
    implements Iterator<T> {
        private int pointer;
        private boolean circularity = false;
        private int finishIndex;

        public LastItemsIterator() {
            this(-1);
        }

        public LastItemsIterator(int startIndex) {
            int arrayPrePointerIndex = CircularArray.this.pointer - 1;
            if (CircularArray.this.size < CircularArray.this.length) {
                this.pointer = startIndex < 0 ? -1 : startIndex;
                this.finishIndex = CircularArray.this.size - 1;
                return;
            }
            this.pointer = startIndex < 0 ? arrayPrePointerIndex : startIndex;
            this.finishIndex = arrayPrePointerIndex;
            if (this.pointer >= this.finishIndex && startIndex != arrayPrePointerIndex) {
                this.circularity = true;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.circularity) {
                if (this.pointer == CircularArray.this.length - 1) {
                    this.pointer = -1;
                    this.circularity = false;
                }
                return true;
            }
            return this.pointer < this.finishIndex;
        }

        @Override
        public T next() {
            return CircularArray.this.array[++this.pointer];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class PlainIterator
    implements Iterator<T> {
        private int pointer = 0;

        private PlainIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < CircularArray.this.size;
        }

        @Override
        public T next() {
            return CircularArray.this.array[this.pointer++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

