/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.concurrent;

import com.github.akurilov.commons.concurrent.Throttle;
import java.util.concurrent.TimeUnit;

public final class RateThrottle<X>
implements Throttle<X> {
    private final long periodNanos;
    private volatile long startTime = -1L;
    private volatile long acquiredCount = 0L;

    public RateThrottle(double rateLimit) {
        if (rateLimit <= 0.0) {
            throw new IllegalArgumentException("Rate limit should be more than 0, but got " + rateLimit);
        }
        this.periodNanos = (long)((double)TimeUnit.SECONDS.toNanos(1L) / rateLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean tryAcquire(X item) {
        RateThrottle rateThrottle = this;
        synchronized (rateThrottle) {
            if (this.startTime > 0L) {
                long periodCount = (System.nanoTime() - this.startTime) / this.periodNanos;
                if (periodCount > this.acquiredCount) {
                    ++this.acquiredCount;
                    return true;
                }
                return false;
            }
            this.startTime = System.nanoTime();
            ++this.acquiredCount;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int tryAcquire(X item, int requiredCount) {
        RateThrottle rateThrottle = this;
        synchronized (rateThrottle) {
            if (this.startTime > 0L) {
                int availableCount = (int)((System.nanoTime() - this.startTime) / this.periodNanos - this.acquiredCount);
                if (availableCount > requiredCount) {
                    this.acquiredCount += (long)requiredCount;
                    return requiredCount;
                }
                this.acquiredCount += (long)availableCount;
                return availableCount;
            }
            this.startTime = System.nanoTime();
            this.acquiredCount += (long)requiredCount;
            return requiredCount;
        }
    }
}

