/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public abstract class IoUtil {
    public static final int REUSABLE_BUFF_SIZE_MIN = 1;
    public static final int REUSABLE_BUFF_SIZE_MAX = 0x1000000;
    private static final ThreadLocal<ReadableByteChannel[]> REUSABLE_INPUT_CHANNELS = ThreadLocal.withInitial(() -> {
        int count = (int)(Math.log(1.6777216E7) / Math.log(2.0) + 1.0);
        return new ReadableByteChannel[count];
    });
    private static final ThreadLocal<WritableByteChannel[]> REUSABLE_OUTPUT_CHANNELS = ThreadLocal.withInitial(() -> {
        int count = (int)(Math.log(1.6777216E7) / Math.log(2.0) + 1.0);
        return new WritableByteChannel[count];
    });

    private IoUtil() {
    }

    public static ReadableByteChannel getThreadLocalInputChannel(InputStream in, long remainingSize) throws IllegalStateException {
        if (remainingSize < 0L) {
            throw new IllegalArgumentException("Requested negative size: " + remainingSize);
        }
        ReadableByteChannel[] threadLocalReusableChannels = REUSABLE_INPUT_CHANNELS.get();
        long currBuffSize = Long.highestOneBit(remainingSize);
        if (currBuffSize > 0x1000000L) {
            currBuffSize = 0x1000000L;
        } else if (currBuffSize < 0x1000000L) {
            if (currBuffSize < 1L) {
                currBuffSize = 1L;
            } else if (currBuffSize < remainingSize) {
                currBuffSize <<= 1;
            }
        }
        int i = Long.numberOfTrailingZeros(currBuffSize);
        ReadableByteChannel chan = threadLocalReusableChannels[i];
        if (chan == null) {
            threadLocalReusableChannels[i] = chan = new InputStreamWrapperChannel(in, (int)currBuffSize);
        }
        return chan;
    }

    public static WritableByteChannel getThreadLocalOutputChannel(OutputStream out, long remainingSize) throws IllegalStateException {
        if (remainingSize < 0L) {
            throw new IllegalArgumentException("Requested negative size: " + remainingSize);
        }
        WritableByteChannel[] threadLocalReusableChannels = REUSABLE_OUTPUT_CHANNELS.get();
        long currBuffSize = Long.highestOneBit(remainingSize);
        if (currBuffSize > 0x1000000L) {
            currBuffSize = 0x1000000L;
        } else if (currBuffSize < 0x1000000L) {
            if (currBuffSize < 1L) {
                currBuffSize = 1L;
            } else if (currBuffSize < remainingSize) {
                currBuffSize <<= 1;
            }
        }
        int i = Long.numberOfTrailingZeros(currBuffSize);
        WritableByteChannel chan = threadLocalReusableChannels[i];
        if (chan == null) {
            threadLocalReusableChannels[i] = chan = new OutputStreamWrapperChannel(out, (int)currBuffSize);
        }
        return chan;
    }

    private static final class OutputStreamWrapperChannel
    implements WritableByteChannel {
        private final OutputStream out;
        private final byte[] bb;

        private OutputStreamWrapperChannel(OutputStream out, int buffSize) {
            this.out = out;
            this.bb = new byte[buffSize];
        }

        @Override
        public final int write(ByteBuffer src) throws IOException {
            int n = Math.min(this.bb.length, src.remaining());
            if (n > 0) {
                src.get(this.bb, 0, n);
                this.out.write(this.bb, 0, n);
            }
            return n;
        }

        @Override
        public final boolean isOpen() {
            return true;
        }

        @Override
        public final void close() throws IOException {
        }
    }

    private static final class InputStreamWrapperChannel
    implements ReadableByteChannel {
        private final InputStream in;
        private final byte[] bb;

        private InputStreamWrapperChannel(InputStream in, int buffSize) {
            this.in = in;
            this.bb = new byte[buffSize];
        }

        @Override
        public final int read(ByteBuffer dst) throws IOException {
            int n = this.in.read(this.bb, 0, Math.min(this.bb.length, dst.remaining()));
            dst.put(this.bb, 0, n);
            return n;
        }

        @Override
        public final boolean isOpen() {
            return true;
        }

        @Override
        public final void close() throws IOException {
        }
    }
}

