/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io;

import com.github.akurilov.commons.io.Output;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

public abstract class TextStreamOutput
implements Output<String> {
    private static final ThreadLocal<StringBuilder> THRLOC_STRB = new ThreadLocal<StringBuilder>(){

        @Override
        protected final StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    private static final String LINE_SEP = System.getProperty("line.separator");
    protected final BufferedWriter writer;

    public TextStreamOutput(OutputStream out) throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter(out));
    }

    public TextStreamOutput(OutputStream out, int buffSize) throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter(out), buffSize);
    }

    @Override
    public boolean put(String line) throws IOException {
        this.writer.write(line + LINE_SEP);
        return true;
    }

    @Override
    public int put(List<String> lines, int from, int to) throws IOException {
        StringBuilder strb = THRLOC_STRB.get();
        strb.setLength(0);
        for (int i = from; i < to; ++i) {
            strb.append(lines.get(i));
            strb.append(LINE_SEP);
        }
        this.writer.write(strb.toString());
        return to - from;
    }

    @Override
    public int put(List<String> lines) throws IOException {
        StringBuilder strb = THRLOC_STRB.get();
        strb.setLength(0);
        for (String line : lines) {
            strb.append(line);
            strb.append(LINE_SEP);
        }
        this.writer.write(strb.toString());
        return lines.size();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

