/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.math;

import com.github.akurilov.commons.math.MathUtil;

public final class Random {
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private long seed;

    public Random() {
        this.reset();
    }

    public void reset() {
        this.seed = System.nanoTime() ^ System.currentTimeMillis();
    }

    public Random(long seed) {
        this.seed = seed;
    }

    public final long nextLong() {
        this.seed = MathUtil.xorShift(this.seed);
        return this.seed;
    }

    public final long nextLong(long range) {
        return Math.abs(this.nextLong() % range);
    }

    public final int nextInt() {
        return (int)this.nextLong();
    }

    public final int nextInt(int range) {
        return (int)this.nextLong(range);
    }

    public final double nextDouble() {
        this.seed = MathUtil.xorShift(this.seed);
        return (double)((this.seed >>> 22 << 27) + (this.seed >>> 21)) * (double)1.110223E-16f;
    }
}

